/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.core.data;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.function.Predicate;
import org.eclipse.core.runtime.Assert;
import org.eclipse.mylyn.commons.core.CoreUtil;
import org.eclipse.mylyn.tasks.core.ITask;

public class TaskDataFileManager {
    private static final String ENCODING_UTF_8 = "UTF-8";
    private static final String EXTENSION = ".zip";
    private static final String FOLDER_TASKS = "tasks";
    private static final String FOLDER_DATA = "offline";
    private static final String FOLDER_TASKS_1_0 = "offline";
    private static final int FILENAME_MAX_LEN = 255 - ".zip".length();
    private String dataPath;

    public String getDataPath() {
        return this.dataPath;
    }

    public void setDataPath(String dataPath) {
        this.dataPath = dataPath;
    }

    public File getFile(ITask task, String kind) {
        return this.getFile(task.getRepositoryUrl(), task, kind);
    }

    public File getFile(String repositoryUrl, ITask task, String kind) {
        File path = this.getDirectory(repositoryUrl, task);
        String fileName = this.getFileName(task, path);
        return new File(path, fileName + EXTENSION);
    }

    private File getDirectory(String repositoryUrl, ITask task) {
        Assert.isNotNull((Object)this.dataPath);
        String repositoryPath = task.getConnectorKind() + "-" + CoreUtil.asFileName((String)repositoryUrl);
        return new File(this.dataPath + File.separator + FOLDER_TASKS + File.separator + repositoryPath + File.separator + "offline");
    }

    private String getFileName(ITask task, File path) {
        return this.getFileName(task, (String filename) -> new File(path, filename + EXTENSION).exists());
    }

    protected String getFileName(ITask task, Predicate<String> fileExists) {
        String encodedFileName = CoreUtil.asFileName((String)task.getTaskId());
        if (fileExists.test(encodedFileName)) {
            return encodedFileName;
        }
        String fileName = this.requiresEncoding(task.getTaskId()) ? encodedFileName : task.getTaskId();
        return this.trimFilenameIfRequired(fileName);
    }

    private boolean requiresEncoding(String fileName) {
        return !fileName.matches("^[a-zA-Z0-9%\\.]+$");
    }

    private String trimFilenameIfRequired(String filename) {
        if (filename.length() > FILENAME_MAX_LEN) {
            String hashCode = this.getHashCode(filename);
            return filename.substring(0, FILENAME_MAX_LEN - hashCode.length() - 1) + "." + hashCode;
        }
        return filename;
    }

    private String getHashCode(String text) {
        return Integer.toUnsignedString(text.hashCode());
    }

    public File getFile10(ITask task, String kind) {
        try {
            String pathName = URLEncoder.encode(task.getRepositoryUrl(), ENCODING_UTF_8);
            String fileName = task.getTaskId() + EXTENSION;
            File path = new File(this.dataPath + File.separator + "offline", pathName);
            return new File(path, fileName);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }
}

