/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.fix;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.PrefixExpression;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.refactoring.CompilationUnitChange;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.fix.CompilationUnitRewriteOperationsFixCore;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalModelCore;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.ui.fix.AbstractMultiFix;
import org.eclipse.jdt.internal.ui.fix.MultiFixMessages;
import org.eclipse.jdt.ui.cleanup.CleanUpRequirements;
import org.eclipse.jdt.ui.cleanup.ICleanUpFix;
import org.eclipse.jdt.ui.text.java.IProblemLocation;
import org.eclipse.text.edits.TextEditGroup;

public class DoubleNegationCleanUpCore
extends AbstractMultiFix
implements ICleanUpFix {
    public DoubleNegationCleanUpCore() {
        this(Collections.emptyMap());
    }

    public DoubleNegationCleanUpCore(Map<String, String> options) {
        super(options);
    }

    @Override
    public CleanUpRequirements getRequirements() {
        boolean requireAST = this.isEnabled("cleanup.double_negation");
        return new CleanUpRequirements(requireAST, false, false, null);
    }

    @Override
    public String[] getStepDescriptions() {
        if (this.isEnabled("cleanup.double_negation")) {
            return new String[]{MultiFixMessages.DoubleNegationCleanUp_description};
        }
        return new String[0];
    }

    @Override
    public String getPreview() {
        if (this.isEnabled("cleanup.double_negation")) {
            return "boolean b1 = isValid == isEnabled;\nboolean b2 = isValid ^ isEnabled;\nboolean b3 = isValid == isEnabled;\n";
        }
        return "boolean b1 = !isValid == !isEnabled;\nboolean b2 = !isValid != !isEnabled;\nboolean b3 = !isValid ^ isEnabled;\n";
    }

    @Override
    protected ICleanUpFix createFix(CompilationUnit unit) throws CoreException {
        if (!this.isEnabled("cleanup.double_negation")) {
            return null;
        }
        final ArrayList rewriteOperations = new ArrayList();
        unit.accept(new ASTVisitor(){

            public boolean visit(InfixExpression visited) {
                if (ASTNodes.hasOperator(visited, InfixExpression.Operator.EQUALS, InfixExpression.Operator.NOT_EQUALS, InfixExpression.Operator.XOR) && !visited.hasExtendedOperands()) {
                    Expression leftExpression = visited.getLeftOperand();
                    Expression rightExpression = visited.getRightOperand();
                    PrefixExpression leftPrefix = ASTNodes.as(leftExpression, PrefixExpression.class);
                    Expression leftNegatedExpression = null;
                    if (leftPrefix != null && ASTNodes.hasOperator(leftPrefix, PrefixExpression.Operator.NOT, new PrefixExpression.Operator[0])) {
                        leftNegatedExpression = leftPrefix.getOperand();
                    }
                    PrefixExpression rightPrefix = ASTNodes.as(rightExpression, PrefixExpression.class);
                    Expression rightNegatedExpression = null;
                    if (rightPrefix != null && ASTNodes.hasOperator(rightPrefix, PrefixExpression.Operator.NOT, new PrefixExpression.Operator[0])) {
                        rightNegatedExpression = rightPrefix.getOperand();
                    }
                    if (leftNegatedExpression != null || rightNegatedExpression != null) {
                        rewriteOperations.add(new DoubleNegationOperation(visited, leftExpression, rightExpression, leftNegatedExpression, rightNegatedExpression));
                        return false;
                    }
                }
                return true;
            }
        });
        if (rewriteOperations.isEmpty()) {
            return null;
        }
        return new CompilationUnitRewriteOperationsFixCore(MultiFixMessages.DoubleNegationCleanUp_description, unit, rewriteOperations.toArray(new CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperationWithSourceRange[0]));
    }

    @Override
    public CompilationUnitChange createChange(IProgressMonitor progressMonitor) throws CoreException {
        return null;
    }

    @Override
    public boolean canFix(ICompilationUnit compilationUnit, IProblemLocation problem) {
        return false;
    }

    @Override
    protected ICleanUpFix createFix(CompilationUnit unit, IProblemLocation[] problems) throws CoreException {
        return null;
    }

    private static class DoubleNegationOperation
    extends CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperationWithSourceRange {
        private final InfixExpression visited;
        private final Expression leftExpression;
        private final Expression rightExpression;
        private final Expression leftNegatedExpression;
        private final Expression rightNegatedExpression;

        public DoubleNegationOperation(InfixExpression visited, Expression leftExpression, Expression rightExpression, Expression leftNegatedExpression, Expression rightNegatedExpression) {
            this.visited = visited;
            this.leftExpression = leftExpression;
            this.rightExpression = rightExpression;
            this.leftNegatedExpression = leftNegatedExpression;
            this.rightNegatedExpression = rightNegatedExpression;
        }

        @Override
        public void rewriteASTInternal(CompilationUnitRewrite cuRewrite, LinkedProposalModelCore linkedModel) throws CoreException {
            ASTRewrite rewrite = cuRewrite.getASTRewrite();
            AST ast = cuRewrite.getRoot().getAST();
            TextEditGroup group = this.createTextEditGroup(MultiFixMessages.DoubleNegationCleanUp_description, cuRewrite);
            InfixExpression newInfixExpression = ast.newInfixExpression();
            if (this.leftNegatedExpression != null) {
                newInfixExpression.setLeftOperand(ASTNodes.createMoveTarget(rewrite, this.leftNegatedExpression));
                if (this.rightNegatedExpression != null) {
                    newInfixExpression.setOperator(DoubleNegationOperation.getAppropriateOperator(this.visited));
                    newInfixExpression.setRightOperand(ASTNodes.createMoveTarget(rewrite, this.rightNegatedExpression));
                } else {
                    newInfixExpression.setOperator(DoubleNegationOperation.getNegatedOperator(this.visited));
                    newInfixExpression.setRightOperand(ASTNodes.createMoveTarget(rewrite, this.rightExpression));
                }
            } else {
                newInfixExpression.setLeftOperand(ASTNodes.createMoveTarget(rewrite, this.leftExpression));
                newInfixExpression.setOperator(DoubleNegationOperation.getNegatedOperator(this.visited));
                newInfixExpression.setRightOperand(ASTNodes.createMoveTarget(rewrite, this.rightNegatedExpression));
            }
            ASTNodes.replaceButKeepComment(rewrite, (ASTNode)this.visited, (ASTNode)newInfixExpression, group);
        }

        private static InfixExpression.Operator getNegatedOperator(InfixExpression expression) {
            if (ASTNodes.hasOperator(expression, InfixExpression.Operator.EQUALS, new InfixExpression.Operator[0])) {
                return InfixExpression.Operator.XOR;
            }
            return InfixExpression.Operator.EQUALS;
        }

        private static InfixExpression.Operator getAppropriateOperator(InfixExpression expression) {
            if (ASTNodes.hasOperator(expression, InfixExpression.Operator.NOT_EQUALS, new InfixExpression.Operator[0])) {
                return InfixExpression.Operator.XOR;
            }
            return expression.getOperator();
        }
    }
}

