/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.typescript.model.api.internal;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.scout.sdk.core.typescript.model.api.IConstantValue;
import org.eclipse.scout.sdk.core.typescript.model.api.IDataType;
import org.eclipse.scout.sdk.core.typescript.model.api.IES6Class;
import org.eclipse.scout.sdk.core.typescript.model.api.IField;
import org.eclipse.scout.sdk.core.typescript.model.api.INodeElementFactory;
import org.eclipse.scout.sdk.core.typescript.model.api.IObjectLiteral;
import org.eclipse.scout.sdk.core.typescript.model.spi.DataTypeSpi;
import org.eclipse.scout.sdk.core.typescript.model.spi.NodeElementFactorySpi;
import org.eclipse.scout.sdk.core.util.Ensure;

public class NodeElementFactoryImplementor
implements INodeElementFactory {
    private final NodeElementFactorySpi m_spi;

    public NodeElementFactoryImplementor(NodeElementFactorySpi spi) {
        this.m_spi = (NodeElementFactorySpi)Ensure.notNull((Object)spi);
    }

    @Override
    public IField createSyntheticField(String name, IDataType dataType, IES6Class declaringClass) {
        return this.m_spi.createSyntheticField(name, dataType.spi(), declaringClass.spi()).api();
    }

    @Override
    public IDataType createObjectLiteralDataType(String name, IObjectLiteral objectLiteral) {
        return this.m_spi.createObjectLiteralDataType(name, objectLiteral.spi()).api();
    }

    @Override
    public IDataType createArrayDataType(IDataType componentDataType, int arrayDimension) {
        return this.m_spi.createArrayDataType(Optional.ofNullable(componentDataType).map(IDataType::spi).orElse(null), arrayDimension).api();
    }

    @Override
    public IDataType createUnionDataType(Collection<IDataType> componentDataTypes) {
        return Optional.ofNullable(componentDataTypes).map(types -> types.stream().filter(Objects::nonNull).map(IDataType::spi).collect(Collectors.toCollection(LinkedHashSet::new))).map(this.m_spi::createUnionDataType).map(DataTypeSpi::api).orElse(null);
    }

    @Override
    public IDataType createIntersectionDataType(Collection<IDataType> componentDataTypes) {
        return Optional.ofNullable(componentDataTypes).map(types -> types.stream().filter(Objects::nonNull).map(IDataType::spi).collect(Collectors.toCollection(LinkedHashSet::new))).map(this.m_spi::createIntersectionDataType).map(DataTypeSpi::api).orElse(null);
    }

    @Override
    public IDataType createConstantValueDataType(IConstantValue constantValue) {
        return this.m_spi.createConstantValueDataType(constantValue).api();
    }

    @Override
    public IES6Class createClassWithTypeArguments(IES6Class clazz, List<IDataType> arguments) {
        List<DataTypeSpi> args = arguments.stream().filter(Objects::nonNull).map(IDataType::spi).toList();
        return this.m_spi.createClassWithTypeArgumentsDataType(clazz.spi(), args).api();
    }
}

