/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.util;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.eclipse.scout.sdk.core.util.Ensure;

public class SuperHierarchySpliterator<T extends ISuperHierarchyElement<T>>
implements Spliterator<T> {
    public static final int DEFAULT_CHARACTERISTICS = 1297;
    private final boolean m_includeSuperClasses;
    private final boolean m_includeSuperInterfaces;
    private final boolean m_includeStartType;
    private final int m_characteristics;
    private final Deque<T> m_dek;
    private final Set<T> m_visitedSuperInterfaces;
    private final T m_startType;

    public SuperHierarchySpliterator(T startType, boolean includeSuperClasses, boolean includeSuperInterfaces, boolean includeStartType) {
        this.m_startType = (ISuperHierarchyElement)Ensure.notNull(startType);
        this.m_includeStartType = includeStartType;
        this.m_includeSuperClasses = includeSuperClasses;
        this.m_includeSuperInterfaces = includeSuperInterfaces;
        boolean isSizeKnown = !includeSuperClasses && !includeSuperInterfaces;
        this.m_characteristics = SuperHierarchySpliterator.getCharacteristics(isSizeKnown);
        this.m_dek = isSizeKnown ? new ArrayDeque<T>(1) : new ArrayDeque<T>();
        this.m_visitedSuperInterfaces = includeSuperInterfaces ? new HashSet<T>() : null;
        if (includeStartType) {
            this.m_dek.addLast(startType);
        } else {
            this.enqueueSuperLevelsOf(startType);
        }
    }

    public static int getCharacteristics(boolean isSizeKnown) {
        int characteristics = 1297;
        if (isSizeKnown) {
            characteristics |= 0x4040;
        }
        return characteristics;
    }

    @Override
    public boolean tryAdvance(Consumer<? super T> action) {
        this.moveToNextValidElement();
        if (!this.isDataAvailable()) {
            return false;
        }
        this.consumeNext(action);
        return true;
    }

    protected void consumeNext(Consumer<? super T> action) {
        action.accept(this.moveToNext());
    }

    protected void moveToNextValidElement() {
        while (this.isDataAvailable()) {
            boolean selfAccepted;
            ISuperHierarchyElement next = (ISuperHierarchyElement)this.m_dek.peekFirst();
            boolean ifcAccepted = this.isIncludeSuperInterfaces() && next.isInterface();
            boolean superClassAccepted = this.isIncludeSuperClasses() && !next.isInterface();
            boolean bl = selfAccepted = this.isIncludeStartType() && next == this.m_startType;
            if (ifcAccepted || superClassAccepted || selfAccepted) {
                return;
            }
            this.moveToNext();
        }
    }

    protected boolean isDataAvailable() {
        return !this.m_dek.isEmpty();
    }

    protected T moveToNext() {
        ISuperHierarchyElement curElement = (ISuperHierarchyElement)this.m_dek.removeFirst();
        this.enqueueSuperLevelsOf(curElement);
        return (T)curElement;
    }

    protected void enqueueSuperLevelsOf(T curLevel) {
        if (!curLevel.isInterface()) {
            curLevel.superClass().ifPresent(this.m_dek::addLast);
        }
        if (!this.isIncludeSuperInterfaces()) {
            return;
        }
        curLevel.superInterfaces().filter(this.m_visitedSuperInterfaces::add).forEach(this.m_dek::addLast);
    }

    @Override
    public Spliterator<T> trySplit() {
        return null;
    }

    @Override
    public long estimateSize() {
        if (this.hasCharacteristics(64)) {
            if (this.isIncludeStartType()) {
                return 1L;
            }
            return 0L;
        }
        return Long.MAX_VALUE;
    }

    @Override
    public int characteristics() {
        return this.m_characteristics;
    }

    protected boolean isIncludeSuperClasses() {
        return this.m_includeSuperClasses;
    }

    protected boolean isIncludeSuperInterfaces() {
        return this.m_includeSuperInterfaces;
    }

    protected boolean isIncludeStartType() {
        return this.m_includeStartType;
    }

    public static interface ISuperHierarchyElement<T> {
        public boolean isInterface();

        public Optional<T> superClass();

        public Stream<T> superInterfaces();
    }
}

