/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.dialogs;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.PageBook;
import org.eclipse.wst.wsdl.internal.generator.BaseGenerator;
import org.eclipse.wst.wsdl.internal.generator.BindingGenerator;
import org.eclipse.wst.wsdl.ui.internal.Messages;
import org.eclipse.wst.wsdl.ui.internal.WSDLEditorPlugin;
import org.eclipse.wst.wsdl.ui.internal.asd.ASDEditorCSHelpIds;
import org.eclipse.wst.wsdl.ui.internal.asd.contentgenerator.ui.extension.ContentGeneratorUIExtension;
import org.eclipse.wst.wsdl.ui.internal.asd.contentgenerator.ui.extension.ContentGeneratorUIExtensionRegistry;
import org.eclipse.wst.wsdl.ui.internal.wizards.ContentGeneratorOptionsPage;

public abstract class ProtocolComponentControl
extends Composite
implements SelectionListener,
ModifyListener {
    protected BaseGenerator generator;
    protected Text componentNameField;
    protected Combo refNameCombo;
    protected Button refBrowseButton;
    protected Combo protocolCombo;
    protected Button overwriteButton;
    protected PageBook pageBook;
    protected Composite emptySettingsPage;
    protected Map pageMap = new HashMap();
    protected String name;
    protected String refName;
    protected String UNSPECIFIED = Messages._UI_UNSPECIFIED;
    private static final String IS_OVERWRITE_APPLICABLE = "IS_OVERWRITE_APPLICABLE";

    public ProtocolComponentControl(Composite parent, BaseGenerator generator, boolean showOverwriteButton) {
        super(parent, 0);
        this.generator = generator;
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        this.setLayoutData(this.createGridData(true, 1));
        Composite labelValueComposite = new Composite((Composite)this, 0);
        labelValueComposite.setLayout((Layout)new GridLayout(2, false));
        labelValueComposite.setLayoutData((Object)this.createGridData(false, 1));
        Label componentNameLabel = new Label(labelValueComposite, 0);
        componentNameLabel.setText(this.getComponentNameLabelText());
        this.componentNameField = new Text(labelValueComposite, 2048);
        GridData gdName = new GridData();
        gdName.horizontalAlignment = 4;
        gdName.grabExcessHorizontalSpace = true;
        this.componentNameField.setLayoutData((Object)gdName);
        this.componentNameField.addModifyListener((ModifyListener)this);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.componentNameField, ASDEditorCSHelpIds.PROTOCOL_COMPONENT_NAME_TEXT);
        Label refNameLabel = new Label(labelValueComposite, 0);
        refNameLabel.setText(this.getRefNameLabelText());
        this.refNameCombo = new Combo(labelValueComposite, 8);
        GridData gdRefName = new GridData();
        gdRefName.horizontalAlignment = 4;
        gdRefName.grabExcessHorizontalSpace = true;
        this.refNameCombo.setLayoutData((Object)gdRefName);
        this.refNameCombo.addSelectionListener((SelectionListener)this);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.refNameCombo, ASDEditorCSHelpIds.PROTOCOL_COMPONENT_REF_COMBO);
        Label protocolLabel = new Label(labelValueComposite, 0);
        protocolLabel.setText(Messages._UI_LABEL_BINDING_PROTOCOL);
        this.protocolCombo = new Combo(labelValueComposite, 8);
        GridData gdProtocol = new GridData();
        gdProtocol.horizontalAlignment = 4;
        gdProtocol.grabExcessHorizontalSpace = true;
        this.protocolCombo.setLayoutData((Object)gdProtocol);
        this.protocolCombo.addSelectionListener((SelectionListener)this);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.protocolCombo, ASDEditorCSHelpIds.PROTOCOL_COMPONENT_PROTOCOL_COMBO);
        if (showOverwriteButton) {
            this.overwriteButton = new Button((Composite)this, 32);
            this.overwriteButton.setText(Messages._UI_CHECKBOX_OVERWRITE);
            this.overwriteButton.addSelectionListener((SelectionListener)this);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.overwriteButton, ASDEditorCSHelpIds.pROTOCOL_COMPONENT_OVERWRITE_CHECKBOX);
        }
        this.pageBook = new PageBook((Composite)this, 0);
        GridData gdFill = new GridData();
        gdFill.horizontalAlignment = 4;
        gdFill.grabExcessHorizontalSpace = true;
        gdFill.verticalAlignment = 4;
        gdFill.grabExcessVerticalSpace = true;
        this.pageBook.setLayoutData((Object)gdFill);
        this.emptySettingsPage = new Composite((Composite)this.pageBook, 0);
        int i = 0;
        while (i < 6) {
            new Label(this.emptySettingsPage, 0);
            ++i;
        }
    }

    public void initFields() {
        this.componentNameField.setText(this.getDefaultName());
        this.updateRefNameCombo();
        this.updateProtocolCombo();
        this.updatePageBook(this.protocolCombo.getText());
    }

    public Text getComponentNameField() {
        return this.componentNameField;
    }

    public String getComponentNameLabelText() {
        return Messages._UI_LABEL_NAME;
    }

    private GridData createGridData(boolean both, int span) {
        GridData gd = new GridData(both ? 1808 : 768);
        gd.horizontalSpan = span;
        return gd;
    }

    public void widgetDefaultSelected(SelectionEvent event) {
    }

    public void widgetSelected(SelectionEvent event) {
        if (event.widget == this.overwriteButton && this.overwriteButton != null) {
            this.generator.setOverwrite(this.overwriteButton.getSelection());
        } else if (event.widget == this.refNameCombo) {
            int index = this.refNameCombo.getSelectionIndex();
            String refName = this.refNameCombo.getItem(index);
            if (refName.equals(this.UNSPECIFIED)) {
                this.generator.setRefName("");
            } else {
                this.generator.setRefName(refName);
            }
        } else if (event.widget == this.protocolCombo) {
            int index = this.protocolCombo.getSelectionIndex();
            String protocol = index != -1 ? this.protocolCombo.getItem(index) : null;
            ContentGeneratorUIExtension ext = WSDLEditorPlugin.getInstance().getContentGeneratorUIExtensionRegistry().getExtensionForLabel(protocol);
            if (ext != null) {
                String namespace = ext.getNamespace();
                this.generator.setContentGenerator(BindingGenerator.getContentGenerator((String)namespace));
            } else {
                this.generator.setContentGenerator(null);
            }
            this.updatePageBook(protocol);
        }
    }

    protected void updatePageBook(String protocol) {
        if (protocol != null) {
            ContentGeneratorOptionsPage page = (ContentGeneratorOptionsPage)this.pageMap.get(protocol);
            if (page == null && (page = this.createContentGeneratorOptionsPage(protocol)) != null) {
                page.init(this.generator);
                Composite control = page.createControl((Composite)this.pageBook);
                control.setData(IS_OVERWRITE_APPLICABLE, (Object)new Boolean(page.isOverwriteApplicable()));
                this.pageMap.put(protocol, page);
            }
            boolean enableOverwriteButton = true;
            if (page != null) {
                if (this.overwriteButton != null) {
                    Boolean data = (Boolean)page.getControl().getData(IS_OVERWRITE_APPLICABLE);
                    enableOverwriteButton = data == null || data.equals(Boolean.TRUE);
                }
                this.pageBook.showPage((Control)page.getControl());
                this.pageBook.layout();
                this.pageBook.getParent().layout();
                Point size = this.pageBook.getShell().getSize();
                Point minSize = this.pageBook.getShell().computeSize(-1, -1, true);
                int newX = Math.max(size.x, minSize.x);
                int newY = Math.max(size.y, minSize.y);
                this.pageBook.getShell().setSize(newX, newY);
                page.setOptionsOnGenerator();
            } else {
                this.pageBook.showPage((Control)this.emptySettingsPage);
            }
            if (this.overwriteButton != null) {
                if (enableOverwriteButton) {
                    this.overwriteButton.setEnabled(true);
                    this.overwriteButton.setSelection(this.generator.getOverwrite());
                } else {
                    this.overwriteButton.setEnabled(false);
                    this.overwriteButton.setSelection(true);
                }
            }
        }
    }

    protected void updateProtocolCombo() {
        this.protocolCombo.removeAll();
        this.protocolCombo.add(this.UNSPECIFIED);
        ContentGeneratorUIExtensionRegistry registry = WSDLEditorPlugin.getInstance().getContentGeneratorUIExtensionRegistry();
        List bindingNames = registry.getBindingExtensionNames();
        String protocolText = this.generator.getProtocol();
        ContentGeneratorUIExtension extt = registry.getExtensionForName(protocolText);
        if (extt != null) {
            protocolText = extt.getLabel();
        }
        for (String protocol : bindingNames) {
            String label;
            ContentGeneratorUIExtension ext = registry.getExtensionForName(protocol);
            if (ext == null || (label = ext.getLabel()) == null) continue;
            this.protocolCombo.add(label);
        }
        if (protocolText == null && this.protocolCombo.getItemCount() > 0) {
            protocolText = this.protocolCombo.getItem(0);
        }
        this.protocolCombo.setText(protocolText);
    }

    protected void updateRefNameCombo() {
        this.refNameCombo.removeAll();
        this.refNameCombo.add(this.UNSPECIFIED);
        Iterator i = this.getRefNames().iterator();
        while (i.hasNext()) {
            this.refNameCombo.add((String)i.next());
        }
        if (this.refNameCombo.getItemCount() > 0) {
            String refText = this.generator.getRefName();
            this.refNameCombo.setText(refText != null ? refText : this.UNSPECIFIED);
        }
    }

    public void modifyText(ModifyEvent e) {
        this.generator.setName(this.componentNameField.getText());
    }

    public abstract List getRefNames();

    public abstract String getRefNameLabelText();

    public abstract String getDefaultName();

    public abstract ContentGeneratorOptionsPage createContentGeneratorOptionsPage(String var1);
}

