/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.commands;

import java.util.Iterator;
import javax.xml.namespace.QName;
import org.eclipse.emf.common.util.EList;
import org.eclipse.wst.wsdl.Input;
import org.eclipse.wst.wsdl.Message;
import org.eclipse.wst.wsdl.MessageReference;
import org.eclipse.wst.wsdl.Operation;
import org.eclipse.wst.wsdl.Part;
import org.eclipse.wst.wsdl.ui.internal.adapters.visitor.W11FindInnerElementVisitor;
import org.eclipse.wst.wsdl.ui.internal.commands.AddBaseParameterCommand;
import org.eclipse.wst.wsdl.ui.internal.commands.AddInputCommand;
import org.eclipse.wst.wsdl.ui.internal.commands.AddMessageCommand;
import org.eclipse.wst.wsdl.ui.internal.commands.AddPartCommand;
import org.eclipse.wst.wsdl.ui.internal.util.ComponentReferenceUtil;
import org.eclipse.wst.wsdl.ui.internal.util.NameUtil;
import org.eclipse.wst.wsdl.ui.internal.util.XSDComponentHelper;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDModelGroup;
import org.eclipse.xsd.XSDNamedComponent;
import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDTypeDefinition;

public class AddInputParameterCommand
extends AddBaseParameterCommand {
    protected boolean createXSDObjects = true;
    protected boolean reuseExistingMessage = false;
    private Input input;

    public AddInputParameterCommand(Operation operation, int style) {
        super(operation, style);
    }

    public AddInputParameterCommand(Operation operation, int style, boolean reuseMessage) {
        super(operation, style);
        this.reuseExistingMessage = reuseMessage;
    }

    @Override
    public void run() {
        Part part = null;
        if (this.operation.getEInput() != null) {
            this.input = this.operation.getEInput();
        } else {
            AddInputCommand command = new AddInputCommand(this.operation, null);
            command.run();
            this.input = (Input)command.getWSDLElement();
        }
        part = this.style == AddBaseParameterCommand.PART_ELEMENT_SEQ_ELEMENT ? this.createDocLitWrappedWSDLComponents((MessageReference)this.input) : this.createWSDLComponents((MessageReference)this.input);
        this.newPart = part;
        if (this.createXSDObjects) {
            this.newXSDElement = this.createXSDObjects(part);
        }
    }

    protected Part createDocLitWrappedWSDLComponents(MessageReference messageRef) {
        Message message = messageRef.getEMessage();
        Part part = null;
        if (this.reuseExistingMessage && message == null) {
            Message existingMessage = null;
            String messageName = this.getIdealMessageName(messageRef);
            for (Message item : messageRef.getEnclosingDefinition().getEMessages()) {
                QName itemName = item.getQName();
                if (itemName == null || itemName.getLocalPart() == null || !messageName.equals(itemName.getLocalPart())) continue;
                existingMessage = item;
                break;
            }
            if (existingMessage != null && existingMessage.getEParts().size() > 0) {
                Part existingPart = (Part)existingMessage.getEParts().get(0);
                if (!existingPart.getName().equals(this.getDocLitWrappedPartName())) {
                    message = null;
                } else {
                    W11FindInnerElementVisitor visitor;
                    XSDElementDeclaration innerElement;
                    XSDElementDeclaration existingElement = existingPart.getElementDeclaration();
                    if (existingElement != null && existingElement.getName().equals(this.operation.getName()) && !(innerElement = (visitor = new W11FindInnerElementVisitor()).getInnerXSDElement(existingElement)).equals(existingElement)) {
                        this.createXSDObjects = false;
                        messageRef.setEMessage(existingMessage);
                        message = existingMessage;
                    }
                }
            }
        }
        if (message == null || message.eContainer() == null) {
            AddMessageCommand command = new AddMessageCommand(messageRef.getEnclosingDefinition(), this.getWSDLMessageName());
            command.run();
            message = (Message)command.getWSDLElement();
            messageRef.setEMessage(message);
        }
        if (message.getEParts().size() == 0) {
            String partName = this.getDocLitWrappedPartName();
            AddPartCommand command = new AddPartCommand(message, partName);
            command.run();
            part = (Part)command.getWSDLElement();
        } else {
            part = (Part)message.getEParts().get(0);
        }
        this.formatChild(message.getElement());
        return part;
    }

    @Override
    protected String getAnonymousXSDElementBaseName() {
        if (this.newAnonymousXSDElementName == null) {
            this.newAnonymousXSDElementName = this.style == AddBaseParameterCommand.PART_ELEMENT_SEQ_ELEMENT ? this.operation.getName() : this.getWSDLPartName();
        }
        return this.newAnonymousXSDElementName;
    }

    @Override
    protected String getNewXSDElementBaseName() {
        if (this.newXSDElementName == null) {
            this.newXSDElementName = "in";
        }
        return this.newXSDElementName;
    }

    @Override
    protected String getWSDLMessageName() {
        if (this.newWSDLMessageName == null && this.operation.getEInput() != null) {
            this.newWSDLMessageName = NameUtil.getMessageName((MessageReference)this.operation.getEInput());
        }
        return this.newWSDLMessageName;
    }

    @Override
    protected String getWSDLPartName() {
        if (this.newWSDLPartName == null) {
            this.newWSDLPartName = NameUtil.getPartName((MessageReference)this.operation.getEInput());
        }
        return this.newWSDLPartName;
    }

    @Override
    protected XSDElementDeclaration createPartElementSeqElementPattern(Part part, XSDElementDeclaration partElement) {
        XSDElementDeclaration returnedXSDElement = null;
        XSDElementDeclaration originalElement = null;
        XSDElementDeclaration anonXSDElement = null;
        if (partElement == null || partElement.getAnonymousTypeDefinition() == null) {
            String prefixedName;
            XSDElementDeclaration existingElement = null;
            String idealElementName = this.getAnonymousXSDElementBaseName();
            XSDSchema schema = XSDComponentHelper.getXSDSchema(part.getEnclosingDefinition());
            if (schema != null) {
                Iterator it = schema.getElementDeclarations().iterator();
                while (existingElement == null && it.hasNext()) {
                    XSDParticle innerParticle;
                    EList innerContents;
                    XSDModelGroup modelGroup;
                    EList modelContents;
                    XSDParticle particle;
                    EList particleContents;
                    EList contents;
                    XSDElementDeclaration item = (XSDElementDeclaration)it.next();
                    if (!item.getName().equals(idealElementName)) continue;
                    existingElement = item;
                    XSDTypeDefinition xsdType = item.getAnonymousTypeDefinition();
                    if (xsdType == null || (contents = xsdType.eContents()).size() <= 0 || !(contents.get(0) instanceof XSDParticle) || (particleContents = (particle = (XSDParticle)contents.get(0)).eContents()).size() <= 0 || !(particleContents.get(0) instanceof XSDModelGroup) || (modelContents = (modelGroup = (XSDModelGroup)particleContents.get(0)).eContents()).size() <= 0 || !(modelContents.get(0) instanceof XSDParticle) || (innerContents = (innerParticle = (XSDParticle)modelContents.get(0)).eContents()).size() <= 0 || !(innerContents.get(0) instanceof XSDElementDeclaration)) continue;
                    String prefixedName2 = this.getPrefixedComponentName(part.getEnclosingDefinition(), (XSDNamedComponent)existingElement);
                    ComponentReferenceUtil.setComponentReference(part, false, prefixedName2);
                    return existingElement;
                }
            }
            if (existingElement == null) {
                anonXSDElement = XSDComponentHelper.createAnonymousXSDElementDefinition(this.getAnonymousXSDElementBaseName(), part);
                prefixedName = this.getPrefixedComponentName(part.getEnclosingDefinition(), (XSDNamedComponent)anonXSDElement);
                ComponentReferenceUtil.setComponentReference(part, false, prefixedName);
                part.setTypeDefinition(null);
                if (partElement != null && partElement.getSchema() != null) {
                    originalElement = partElement;
                    partElement.getSchema().getContents().remove((Object)partElement);
                }
            } else {
                anonXSDElement = existingElement;
                prefixedName = this.getPrefixedComponentName(part.getEnclosingDefinition(), (XSDNamedComponent)existingElement);
                ComponentReferenceUtil.setComponentReference(part, false, prefixedName);
            }
        } else {
            anonXSDElement = partElement;
        }
        XSDModelGroup modelGroup = XSDComponentHelper.getXSDModelGroup(anonXSDElement, part.getEnclosingDefinition());
        returnedXSDElement = XSDComponentHelper.createXSDElementDeclarationCommand(null, this.getNewXSDElementBaseName(), modelGroup);
        XSDComponentHelper.addXSDElementToModelGroup(anonXSDElement, returnedXSDElement);
        if (originalElement != null) {
            XSDComponentHelper.addXSDElementToModelGroup(anonXSDElement, originalElement);
        }
        this.formatChild(anonXSDElement.getElement());
        return returnedXSDElement;
    }

    private String getIdealMessageName(MessageReference messageRef) {
        String messageName = "NewMessage";
        messageName = String.valueOf(this.operation.getName()) + "Request";
        return messageName;
    }

    @Override
    public MessageReference getMessageReference() {
        return this.input;
    }
}

