/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.asd.design.figures;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.swt.graphics.Color;
import org.eclipse.wst.wsdl.ui.internal.asd.design.figures.LinkIconFigure;

public class BaseLinkIconFigure
extends Figure {
    public static int VALID_SCHEMA_LINK_STYLE = 1;
    public static int INVALID_SCHEMA_LINK_STYLE = 2;
    private int linkIconStyle = VALID_SCHEMA_LINK_STYLE;
    private AbstractGraphicalEditPart editPart;
    private List childFigures = new ArrayList();
    public int figureSpacing = 7;

    public BaseLinkIconFigure(AbstractGraphicalEditPart ep) {
        this.editPart = ep;
        ToolbarLayout layout = new ToolbarLayout(true){

            public void layout(IFigure parent) {
                super.layout(parent);
                AbstractGraphicalEditPart ep = BaseLinkIconFigure.this.getAssociatedEditPart();
                IFigure associatedFigure = ep.getFigure();
                if (associatedFigure != null) {
                    Rectangle associatedBounds = associatedFigure.getBounds();
                    int x = associatedBounds.x + associatedBounds.width;
                    int y = associatedBounds.y;
                    int width = BaseLinkIconFigure.this.getSize().width;
                    int height = associatedBounds.height;
                    Rectangle newFigBounds = new Rectangle(x, y, width, height);
                    BaseLinkIconFigure.this.setBounds(newFigBounds);
                    for (IFigure fig : parent.getChildren()) {
                        Point newPoint = new Point(x, y);
                        if (fig instanceof RightInvalidIconFigure) {
                            newPoint.x += BaseLinkIconFigure.this.figureSpacing;
                        }
                        fig.setLocation(newPoint);
                    }
                }
            }
        };
        this.setLayoutManager((LayoutManager)layout);
        this.linkIconStyle = VALID_SCHEMA_LINK_STYLE;
        this.addChildFigure((IFigure)new ValidLinkIconFigure());
    }

    private void removeChildFigures() {
        Iterator it = this.childFigures.iterator();
        while (it.hasNext()) {
            this.remove((IFigure)it.next());
        }
        this.childFigures.clear();
    }

    private void addChildFigure(IFigure fig) {
        this.childFigures.add(fig);
        this.add(fig);
    }

    public void setLinkIconStyle(int style) {
        if (style == VALID_SCHEMA_LINK_STYLE && this.linkIconStyle != VALID_SCHEMA_LINK_STYLE) {
            this.removeChildFigures();
            this.addChildFigure((IFigure)new ValidLinkIconFigure());
        } else if (style == INVALID_SCHEMA_LINK_STYLE && this.linkIconStyle != INVALID_SCHEMA_LINK_STYLE) {
            this.removeChildFigures();
            this.addChildFigure((IFigure)new LeftInvalidIconFigure());
            this.addChildFigure((IFigure)new RightInvalidIconFigure());
        }
        this.linkIconStyle = style;
    }

    public int getLinkIconStyle() {
        return this.linkIconStyle;
    }

    public void setColor(Color color) {
        for (IFigure fig : this.childFigures) {
            fig.setBackgroundColor(color);
            fig.setForegroundColor(color);
        }
    }

    public AbstractGraphicalEditPart getAssociatedEditPart() {
        return this.editPart;
    }

    private class LeftInvalidIconFigure
    extends LinkIconFigure {
        public LeftInvalidIconFigure() {
            super(null);
            PointList points = new PointList();
            points.addPoint(new Point(this.horizontalBuffer + 0, 4 + this.verticalBuffer));
            points.addPoint(new Point(this.horizontalBuffer + 5, 4 + this.verticalBuffer));
            points.addPoint(new Point(this.horizontalBuffer + 7, 0 + this.verticalBuffer));
            points.addPoint(new Point(this.horizontalBuffer + 5, 4 + this.verticalBuffer));
            points.addPoint(new Point(this.horizontalBuffer + 2, 10 + this.verticalBuffer));
            points.addPoint(new Point(this.horizontalBuffer + 4, 6 + this.verticalBuffer));
            points.addPoint(new Point(this.horizontalBuffer + 0, 6 + this.verticalBuffer));
            points.addPoint(new Point(this.horizontalBuffer + 0, 4 + this.verticalBuffer));
            this.setForegroundColor(ColorConstants.lightGray);
            this.setBackgroundColor(ColorConstants.lightGray);
            this.setFill(true);
            this.setPoints(points);
        }

        public Dimension getPreferredSize(int wHint, int hHint) {
            Dimension dimension = super.getPreferredSize(wHint, hHint);
            dimension.width += this.horizontalBuffer;
            return dimension;
        }

        public void setLocation(Point point) {
            super.setLocation(point);
            this.setFigureLocation(point);
        }
    }

    private class RightInvalidIconFigure
    extends LinkIconFigure {
        public RightInvalidIconFigure() {
            super(null);
            PointList points = new PointList();
            points.addPoint(new Point(this.horizontalBuffer + 5, 4 + this.verticalBuffer));
            points.addPoint(new Point(this.horizontalBuffer + 7, 0 + this.verticalBuffer));
            points.addPoint(new Point(this.horizontalBuffer + 5, 4 + this.verticalBuffer));
            points.addPoint(new Point(this.horizontalBuffer + 10, 4 + this.verticalBuffer));
            points.addPoint(new Point(this.horizontalBuffer + 10, 0 + this.verticalBuffer));
            points.addPoint(new Point(this.horizontalBuffer + 15, 5 + this.verticalBuffer));
            points.addPoint(new Point(this.horizontalBuffer + 10, 10 + this.verticalBuffer));
            points.addPoint(new Point(this.horizontalBuffer + 10, 6 + this.verticalBuffer));
            points.addPoint(new Point(this.horizontalBuffer + 4, 6 + this.verticalBuffer));
            points.addPoint(new Point(this.horizontalBuffer + 2, 10 + this.verticalBuffer));
            points.addPoint(new Point(this.horizontalBuffer + 5, 4 + this.verticalBuffer));
            this.setForegroundColor(ColorConstants.lightGray);
            this.setBackgroundColor(ColorConstants.lightGray);
            this.setFill(true);
            this.setPoints(points);
        }

        public void setLocation(Point point) {
            super.setLocation(point);
            this.setFigureLocation(point);
        }
    }

    private class ValidLinkIconFigure
    extends LeftInvalidIconFigure {
        public ValidLinkIconFigure() {
            PointList points = new PointList();
            points.addPoint(new Point(this.horizontalBuffer + 0, 4 + this.verticalBuffer));
            points.addPoint(new Point(this.horizontalBuffer + 15, 4 + this.verticalBuffer));
            points.addPoint(new Point(this.horizontalBuffer + 15, 0 + this.verticalBuffer));
            points.addPoint(new Point(this.horizontalBuffer + 20, 5 + this.verticalBuffer));
            points.addPoint(new Point(this.horizontalBuffer + 15, 10 + this.verticalBuffer));
            points.addPoint(new Point(this.horizontalBuffer + 15, 6 + this.verticalBuffer));
            points.addPoint(new Point(this.horizontalBuffer + 0, 6 + this.verticalBuffer));
            points.addPoint(new Point(this.horizontalBuffer + 0, 4 + this.verticalBuffer));
            this.setForegroundColor(ColorConstants.lightGray);
            this.setBackgroundColor(ColorConstants.lightGray);
            this.setFill(true);
            this.setPoints(points);
        }
    }
}

