/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.asd.design.editpolicies;

import java.util.List;
import java.util.Vector;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.wst.wsdl.ui.internal.asd.actions.ASDDragAction;
import org.eclipse.wst.wsdl.ui.internal.asd.actions.ASDDragReorderAction;
import org.eclipse.wst.wsdl.ui.internal.asd.design.editparts.MessageReferenceEditPart;
import org.eclipse.wst.wsdl.ui.internal.asd.design.editparts.ParameterEditPart;
import org.eclipse.wst.wsdl.ui.internal.asd.facade.IMessageReference;
import org.eclipse.wst.wsdl.ui.internal.asd.facade.IParameter;

public class ASDDragAndDropCommand
extends Command {
    protected EditPartViewer viewer;
    protected ChangeBoundsRequest request;
    protected Point location;
    protected ASDDragAction dragAction;
    protected boolean canExecute = false;

    public ASDDragAndDropCommand(EditPartViewer viewer, ChangeBoundsRequest request) {
        this.viewer = viewer;
        this.request = request;
        this.location = request.getLocation();
        EditPart targetEditPart = viewer.findObjectAt(this.location);
        if (targetEditPart instanceof ParameterEditPart || targetEditPart instanceof MessageReferenceEditPart) {
            ((GraphicalEditPart)viewer.getRootEditPart()).getFigure().translateToRelative((Translatable)this.location);
            Vector<ASDDragReorderAction> dragActions = new Vector<ASDDragReorderAction>();
            if (request.getType().equals("add children")) {
                IMessageReference messageRef;
                List list = request.getEditParts();
                if (list.size() <= 0) {
                    this.canExecute = false;
                    return;
                }
                GraphicalEditPart movingChildEditPart = (GraphicalEditPart)list.get(0);
                Object model = movingChildEditPart.getModel();
                EditPart pointerEditPart = viewer.findObjectAt(this.location);
                if (model instanceof IParameter) {
                    dragActions.add(new ASDDragReorderAction(movingChildEditPart, pointerEditPart, this.getPointerLocation(this.location)));
                } else if (model instanceof IMessageReference && ((messageRef = (IMessageReference)model).getKind() == 1 || messageRef.getKind() == 2)) {
                    dragActions.add(new ASDDragReorderAction(movingChildEditPart, pointerEditPart, this.getPointerLocation(this.location)));
                }
            }
            for (ASDDragAction this.dragAction : dragActions) {
                this.canExecute = this.dragAction.canExecute();
                if (this.canExecute) break;
            }
        }
    }

    public boolean canExecute() {
        return this.canExecute;
    }

    public void execute() {
        if (this.canExecute) {
            this.dragAction.run();
        }
    }

    public IFigure getFeedbackFigure() {
        if (this.dragAction != null) {
            return this.dragAction.getFeedbackFigure();
        }
        return null;
    }

    private Point getPointerLocation(Point origPointerLocation) {
        Point compensatedLocation = origPointerLocation;
        FigureCanvas figureCanvas = (FigureCanvas)this.viewer.getControl();
        int yOffset = figureCanvas.getViewport().getVerticalRangeModel().getValue();
        compensatedLocation.y += yOffset;
        return compensatedLocation;
    }
}

