/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.context.ui.state;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchPage;

public class E4EditorReflector {
    private static final String MODEL_ELEMENT_ID = "org.eclipse.e4.ui.compatibility.editor";
    Class<?> eModelServiceClazz;
    Class<?> mUiElementClazz;
    Class<?> mPartClazz;
    private Class<?> ePartServiceClazz;
    private Class<?> partStateClazz;
    private Class<?> mApplicationElementClazz;

    public E4EditorReflector() {
        try {
            this.eModelServiceClazz = Class.forName("org.eclipse.e4.ui.workbench.modeling.EModelService");
            this.ePartServiceClazz = Class.forName("org.eclipse.e4.ui.workbench.modeling.EPartService");
            this.partStateClazz = Class.forName("org.eclipse.e4.ui.workbench.modeling.EPartService$PartState");
            this.mUiElementClazz = Class.forName("org.eclipse.e4.ui.model.application.ui.MUIElement");
            this.mPartClazz = Class.forName("org.eclipse.e4.ui.model.application.ui.basic.MPart");
            this.mApplicationElementClazz = Class.forName("org.eclipse.e4.ui.model.application.MApplicationElement");
        }
        catch (Exception e) {
            throw this.handleException(e);
        }
    }

    private RuntimeException handleException(Exception e) {
        return new RuntimeException(e);
    }

    public List<?> findElements(IWorkbenchPage page) {
        try {
            Method getWindowModel = page.getClass().getDeclaredMethod("getWindowModel", new Class[0]);
            Object windowModel = getWindowModel.invoke((Object)page, new Object[0]);
            Object modelService = this.getModelService();
            Method findElements = this.eModelServiceClazz.getDeclaredMethod("findElements", this.mUiElementClazz, String.class, Class.class, List.class, Integer.TYPE);
            List editors = (List)findElements.invoke(modelService, windowModel, MODEL_ELEMENT_ID, this.mPartClazz, null, 8);
            return editors;
        }
        catch (Exception e) {
            throw this.handleException(e);
        }
    }

    private Object getModelService() {
        return PlatformUI.getWorkbench().getService(this.eModelServiceClazz);
    }

    private Object getPartService(IWorkbenchWindow window) {
        return window.getService(this.ePartServiceClazz);
    }

    public Map<String, String> getPersistedState(Object editor) {
        try {
            Method getPersistedStateMethod = this.mApplicationElementClazz.getDeclaredMethod("getPersistedState", new Class[0]);
            Map persistedState = (Map)getPersistedStateMethod.invoke(editor, new Object[0]);
            return persistedState;
        }
        catch (Exception e) {
            throw this.handleException(e);
        }
    }

    public Object createPart(IWorkbenchWindow window) {
        try {
            Object partService = this.getPartService(window);
            Method method = this.ePartServiceClazz.getDeclaredMethod("createPart", String.class);
            return method.invoke(partService, MODEL_ELEMENT_ID);
        }
        catch (Exception e) {
            throw this.handleException(e);
        }
    }

    public IEditorReference showPart(WorkbenchPage page, Object editorPart) {
        try {
            Method method = this.mApplicationElementClazz.getDeclaredMethod("getElementId", new Class[0]);
            String elementId = (String)method.invoke(editorPart, new Object[0]);
            method = WorkbenchPage.class.getDeclaredMethod("createEditorReferenceForPart", this.mPartClazz, IEditorInput.class, String.class, IMemento.class);
            Object editorReference = method.invoke((Object)page, editorPart, null, elementId, null);
            Object partService = this.getPartService(page.getWorkbenchWindow());
            Object partStateActivate = this.partStateClazz.getEnumConstants()[0];
            method = this.ePartServiceClazz.getDeclaredMethod("showPart", this.mPartClazz, this.partStateClazz);
            method.invoke(partService, editorPart, partStateActivate);
            return (IEditorReference)editorReference;
        }
        catch (Exception e) {
            throw this.handleException(e);
        }
    }
}

