/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.json.core.cleanup;

import org.eclipse.core.runtime.Preferences;
import org.eclipse.wst.json.core.JSONCorePlugin;
import org.eclipse.wst.json.core.cleanup.IJSONCleanupStrategy;

public class JSONCleanupStrategyImpl
implements IJSONCleanupStrategy {
    private static IJSONCleanupStrategy instance = null;
    protected short fIdentCase = 0;
    protected short fPropNameCase = 0;
    protected short fPropValueCase = 0;
    protected short fSelectorTagCase = (short)2;
    protected boolean fQuoteValues = true;
    protected boolean fFormatSource = true;
    protected short fClassCase = 0;
    protected short fIdCase = 0;

    protected JSONCleanupStrategyImpl() {
        this.initialize();
    }

    @Override
    public short getIdentCase() {
        return this.fIdentCase;
    }

    public static synchronized IJSONCleanupStrategy getInstance() {
        if (instance == null) {
            instance = new JSONCleanupStrategyImpl();
        }
        return instance;
    }

    @Override
    public short getPropNameCase() {
        return this.fPropNameCase;
    }

    @Override
    public short getPropValueCase() {
        return this.fPropValueCase;
    }

    @Override
    public short getSelectorTagCase() {
        return this.fSelectorTagCase;
    }

    private void initialize() {
        Preferences prefs = JSONCorePlugin.getDefault().getPluginPreferences();
        this.fQuoteValues = prefs.getBoolean("quoteAttrValues");
        this.fFormatSource = prefs.getBoolean("formatSource");
    }

    private short getCleanupCaseValue(int value) {
        switch (value) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
        }
        return 0;
    }

    @Override
    public boolean isFormatSource() {
        return this.fFormatSource;
    }

    @Override
    public boolean isQuoteValues() {
        return this.fQuoteValues;
    }

    @Override
    public void setFormatSource(boolean formatSource) {
        this.fFormatSource = formatSource;
    }

    @Override
    public void setIdentCase(short identCase) {
        this.fIdentCase = identCase;
    }

    @Override
    public void setPropNameCase(short propNameCase) {
        this.fPropNameCase = propNameCase;
    }

    @Override
    public void setPropValueCase(short propValueCase) {
        this.fPropValueCase = propValueCase;
    }

    @Override
    public void setQuoteValues(boolean quoteValues) {
        this.fQuoteValues = quoteValues;
    }

    @Override
    public void setSelectorTagCase(short selectorTagCase) {
        this.fSelectorTagCase = selectorTagCase;
    }

    public void saveOptions() {
        JSONCorePlugin.getDefault().getPluginPreferences().setValue("quoteAttrValues", this.fQuoteValues);
        JSONCorePlugin.getDefault().getPluginPreferences().setValue("formatSource", this.fFormatSource);
        JSONCorePlugin.getDefault().savePluginPreferences();
    }

    @Override
    public short getClassSelectorCase() {
        return this.fClassCase;
    }

    @Override
    public short getIdSelectorCase() {
        return this.fIdCase;
    }

    @Override
    public void setClassSelectorCase(short classSelectorCase) {
        this.fClassCase = classSelectorCase;
    }

    @Override
    public void setIdSelectorCase(short idSelectorCase) {
        this.fIdCase = idSelectorCase;
    }
}

