/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.internet.cache.internal;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Hashtable;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.internet.cache.internal.LicenseRegistry;
import org.eclipse.wst.internet.cache.internal.ToCacheResource;
import org.osgi.framework.Bundle;

public class ToCacheRegistryReader {
    protected static final String PLUGIN_ID = "org.eclipse.wst.internet.cache";
    protected static final String EXTENSION_POINT_ID = "cacheresource";
    protected static final String ATT_URL = "url";
    protected static final String ATT_LICENSE = "license";
    private static ToCacheRegistryReader registryReader = null;
    private Hashtable resourcesToCache = new Hashtable();

    public static ToCacheRegistryReader getInstance() {
        if (registryReader == null) {
            registryReader = new ToCacheRegistryReader();
        }
        return registryReader;
    }

    public void readRegistry() {
        IExtensionRegistry pluginRegistry = Platform.getExtensionRegistry();
        IExtensionPoint point = pluginRegistry.getExtensionPoint(PLUGIN_ID, EXTENSION_POINT_ID);
        if (point != null) {
            IConfigurationElement[] elements = point.getConfigurationElements();
            int i = 0;
            while (i < elements.length) {
                ToCacheResource toCacheResource = this.readElement(elements[i]);
                if (toCacheResource != null) {
                    this.resourcesToCache.put(toCacheResource.getURL(), toCacheResource);
                    LicenseRegistry.getInstance().addLicense(toCacheResource.getLicense());
                }
                ++i;
            }
        }
    }

    protected ToCacheResource readElement(IConfigurationElement element) {
        String url;
        if (element.getName().equals(EXTENSION_POINT_ID) && (url = element.getAttribute(ATT_URL)) != null) {
            String license = element.getAttribute(ATT_LICENSE);
            try {
                Bundle pluginBundle;
                URL licenseURL;
                URI licenseURI = new URI(license);
                if (!licenseURI.isAbsolute() && (licenseURL = (pluginBundle = Platform.getBundle((String)element.getDeclaringExtension().getContributor().getName())).getEntry(license)) != null) {
                    license = FileLocator.resolve((URL)licenseURL).toExternalForm();
                }
            }
            catch (URISyntaxException uRISyntaxException) {
            }
            catch (IOException iOException) {}
            return new ToCacheResource(url, license);
        }
        return null;
    }

    public String[] getURIsToCache() {
        return this.resourcesToCache.keySet().toArray(new String[this.resourcesToCache.size()]);
    }

    public ToCacheResource getResourceToCache(String url) {
        return (ToCacheResource)this.resourcesToCache.get(url);
    }
}

