/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.callhierarchy;

import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.lsp4e.callhierarchy.CallHierarchyViewTreeNode;
import org.eclipse.lsp4e.ui.LSPImages;
import org.eclipse.lsp4j.CallHierarchyItem;
import org.eclipse.swt.graphics.Image;

public class CallHierarchyLabelProvider
extends LabelProvider
implements DelegatingStyledCellLabelProvider.IStyledLabelProvider {
    public @Nullable Image getImage(@Nullable Object element) {
        CallHierarchyViewTreeNode treeNode;
        CallHierarchyItem callContainer;
        Image res;
        if (element instanceof CallHierarchyViewTreeNode && (res = LSPImages.imageFromSymbolKind((callContainer = (treeNode = (CallHierarchyViewTreeNode)element).getCallContainer()).getKind())) != null) {
            return res;
        }
        return element == null ? null : super.getImage(element);
    }

    public @Nullable StyledString getStyledText(@Nullable Object element) {
        if (element instanceof CallHierarchyViewTreeNode) {
            CallHierarchyViewTreeNode treeNode = (CallHierarchyViewTreeNode)element;
            CallHierarchyItem callContainer = treeNode.getCallContainer();
            StyledString styledString = new StyledString();
            this.appendName(styledString, callContainer.getName());
            if (callContainer.getDetail() != null) {
                this.appendDetail(styledString, callContainer.getDetail());
            }
            return styledString;
        }
        if (element instanceof String) {
            String s = (String)element;
            return new StyledString(s);
        }
        return null;
    }

    protected void appendName(StyledString styledString, String name) {
        int colon = name.lastIndexOf(58);
        if (colon >= 0) {
            styledString.append(name.substring(0, colon));
            styledString.append(name.substring(colon), StyledString.DECORATIONS_STYLER);
        } else {
            styledString.append(name);
        }
    }

    protected void appendDetail(StyledString styledString, String detail) {
        styledString.append(" - ", StyledString.QUALIFIER_STYLER);
        styledString.append(detail, StyledString.QUALIFIER_STYLER);
    }
}

