/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.heapwalking;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.debug.core.IJavaDebugTarget;
import org.eclipse.jdt.internal.debug.core.model.JDIReferenceType;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.heapwalking.AllInstancesActionDelegate;
import org.eclipse.jdt.internal.debug.ui.heapwalking.Messages;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;

public class InstanceCountActionDelegate
extends AllInstancesActionDelegate {
    @Override
    protected void displayInstaces(IAction action, JDIReferenceType rtype) {
        try {
            this.displayNumInstances(rtype.getName(), rtype.getInstanceCount());
        }
        catch (CoreException e) {
            JDIDebugUIPlugin.log(e);
            this.report(Messages.AllInstancesActionDelegate_0, this.getPart());
        }
    }

    @Override
    protected void displayNoInstances(IAction action, IJavaDebugTarget target, String typeName) {
        this.displayNumInstances(typeName, 0L);
    }

    protected void displayNumInstances(String typeName, long instanceCount) {
        String message = null;
        message = instanceCount == 0L ? NLS.bind((String)Messages.InstanceCountActionDelegate_0, (Object)typeName) : (instanceCount == 1L ? NLS.bind((String)Messages.InstanceCountActionDelegate_1, (Object)typeName) : NLS.bind((String)Messages.InstanceCountActionDelegate_2, (Object)Long.toString(instanceCount), (Object)typeName));
        MessageDialog.openInformation((Shell)this.getShell(), (String)Messages.InstanceCountActionDelegate_3, (String)message);
    }
}

