/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wsil.impl.extension.uddi;

import java.util.Vector;
import org.apache.wsil.QName;
import org.apache.wsil.WSILElement;
import org.apache.wsil.WSILException;
import org.apache.wsil.extension.ExtensionElement;
import org.apache.wsil.extension.ExtensionReader;
import org.apache.wsil.extension.uddi.BusinessDescription;
import org.apache.wsil.extension.uddi.ServiceDescription;
import org.apache.wsil.impl.extension.uddi.BusinessDescriptionImpl;
import org.apache.wsil.impl.extension.uddi.ServiceDescriptionImpl;
import org.apache.wsil.util.XMLUtil;
import org.uddi4j.util.BusinessKey;
import org.uddi4j.util.CategoryBag;
import org.uddi4j.util.DiscoveryURL;
import org.uddi4j.util.KeyedReference;
import org.uddi4j.util.ServiceKey;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public class UDDIExtensionReader
implements ExtensionReader {
    @Override
    public ExtensionElement parseElement(Element element, WSILElement wsilElement) throws WSILException {
        ExtensionElement extElement = null;
        QName qname = new QName(element);
        if (qname.equals(ServiceDescription.QNAME) || qname.equals(ServiceDescription.QNAME_V2)) {
            extElement = this.parseServiceDescription(element, wsilElement);
        } else if (qname.equals(BusinessDescription.QNAME) || qname.equals(BusinessDescription.QNAME_V2)) {
            extElement = this.parseBusinessDescription(element, wsilElement);
        } else {
            throw new WSILException("WSIL document contains undefined UDDI extension element: " + element.getTagName() + ".");
        }
        return extElement;
    }

    protected ExtensionElement parseServiceDescription(Element serviceDescriptionElement, WSILElement wsilElement) throws WSILException {
        ServiceDescriptionImpl serviceDescription = new ServiceDescriptionImpl();
        NamedNodeMap attrList = serviceDescriptionElement.getAttributes();
        Attr attr = (Attr)attrList.item(0);
        String location = attr.getValue();
        serviceDescription.setLocation(location);
        Element element = XMLUtil.getFirstChild(serviceDescriptionElement);
        while (element != null) {
            if (ServiceDescription.SERVICE_KEY_QNAME.equals(element) || ServiceDescription.SERVICE_KEY_QNAME_V2.equals(element)) {
                serviceDescription.setServiceKey(this.parseServiceKey(element, serviceDescription));
            } else if (ServiceDescription.DISCOVERY_URL_QNAME.equals(element) || ServiceDescription.DISCOVERY_URL_QNAME_V2.equals(element)) {
                serviceDescription.setDiscoveryURL(this.parseDiscoveryURL(element, serviceDescription));
            } else {
                throw new WSILException("WSIL document contains undefined UDDI extension element: " + element.getTagName() + ".");
            }
            element = XMLUtil.getNextSibling(element);
        }
        return serviceDescription;
    }

    protected ExtensionElement parseBusinessDescription(Element businessDescriptionElement, WSILElement wsilElement) {
        BusinessDescriptionImpl businessDescription = new BusinessDescriptionImpl();
        NamedNodeMap attrList = businessDescriptionElement.getAttributes();
        Attr attr = (Attr)attrList.item(0);
        String location = attr.getValue();
        businessDescription.setLocation(location);
        Element element = XMLUtil.getFirstChild(businessDescriptionElement);
        while (element != null) {
            if (BusinessDescription.BUSINESS_KEY_QNAME.equals(element)) {
                businessDescription.setBusinessKey(this.parseBusinessKey(element, businessDescription));
            } else if (BusinessDescription.DISCOVERY_URL_QNAME.equals(element)) {
                businessDescription.setDiscoveryURL(this.parseDiscoveryURL(element, businessDescription));
            }
            element = XMLUtil.getNextSibling(element);
        }
        return businessDescription;
    }

    protected BusinessKey parseBusinessKey(Element element, WSILElement wsilElement) {
        BusinessKey businessKey = new BusinessKey();
        businessKey.setText(XMLUtil.getText(element));
        return businessKey;
    }

    protected DiscoveryURL parseDiscoveryURL(Element element, WSILElement wsilElement) {
        DiscoveryURL discoveryURL = new DiscoveryURL();
        NamedNodeMap attrList = element.getAttributes();
        Attr attr = (Attr)attrList.item(0);
        String useType = attr.getValue();
        discoveryURL.setUseType(useType);
        discoveryURL.setText(XMLUtil.getText(element));
        return discoveryURL;
    }

    protected ServiceKey parseServiceKey(Element element, WSILElement wsilElement) {
        ServiceKey serviceKey = new ServiceKey();
        serviceKey.setText(XMLUtil.getText(element));
        return serviceKey;
    }

    protected CategoryBag parseCategoryBag(Element categoryBagElement, WSILElement wsilElement) {
        CategoryBag categoryBag = new CategoryBag();
        Element element = XMLUtil.getFirstChild(categoryBagElement);
        NamedNodeMap attrList = element.getAttributes();
        Attr attr = (Attr)attrList.item(0);
        String keyName = attr.getValue();
        attr = (Attr)attrList.item(1);
        String keyValue = attr.getValue();
        KeyedReference keyedReference = new KeyedReference(keyName, keyValue);
        Vector<KeyedReference> keyedReferenceVector = new Vector<KeyedReference>();
        keyedReferenceVector.add(keyedReference);
        categoryBag.setKeyedReferenceVector(keyedReferenceVector);
        return categoryBag;
    }
}

