/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.java.ecj;

import java.io.Serializable;
import java.util.Comparator;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.scout.sdk.core.java.ecj.SpiWithEcjUtils;

final class SourcePositionComparators {
    private static final int UNKNOWN_SOURCE_POS = -1;

    private SourcePositionComparators() {
    }

    public static final class FieldBindingComparator
    implements Comparator<FieldBinding>,
    Serializable {
        public static final Comparator<FieldBinding> INSTANCE = new FieldBindingComparator();
        private static final long serialVersionUID = 1L;

        private FieldBindingComparator() {
        }

        static int getSourcePosition(FieldBinding fb) {
            FieldBinding fieldBinding = SpiWithEcjUtils.nvl(fb.original(), fb);
            FieldDeclaration decl = fieldBinding.sourceField();
            if (decl == null) {
                return -1;
            }
            return decl.declarationSourceStart;
        }

        @Override
        public int compare(FieldBinding o1, FieldBinding o2) {
            int pos1 = FieldBindingComparator.getSourcePosition(o1);
            int pos2 = FieldBindingComparator.getSourcePosition(o2);
            return Integer.compare(pos1, pos2);
        }
    }

    public static final class MethodBindingComparator
    implements Comparator<MethodBinding>,
    Serializable {
        public static final Comparator<MethodBinding> INSTANCE = new MethodBindingComparator();
        private static final long serialVersionUID = 1L;

        private MethodBindingComparator() {
        }

        static int getSourcePosition(MethodBinding mb) {
            MethodBinding methodBinding = SpiWithEcjUtils.nvl(mb.original(), mb);
            AbstractMethodDeclaration decl = SpiWithEcjUtils.sourceMethodOf(methodBinding);
            if (decl == null) {
                return -1;
            }
            return decl.declarationSourceStart;
        }

        @Override
        public int compare(MethodBinding o1, MethodBinding o2) {
            int pos1 = MethodBindingComparator.getSourcePosition(o1);
            int pos2 = MethodBindingComparator.getSourcePosition(o2);
            return Integer.compare(pos1, pos2);
        }
    }

    public static final class TypeBindingComparator
    implements Comparator<TypeBinding>,
    Serializable {
        public static final Comparator<TypeBinding> INSTANCE = new TypeBindingComparator();
        private static final long serialVersionUID = 1L;

        private TypeBindingComparator() {
        }

        static int getSourcePosition(TypeBinding rb) {
            TypeBinding tb = SpiWithEcjUtils.nvl(rb.original(), rb);
            if (!(tb instanceof SourceTypeBinding)) {
                return -1;
            }
            TypeDeclaration decl = ((SourceTypeBinding)tb).scope.referenceContext;
            if (decl == null) {
                return -1;
            }
            return decl.declarationSourceStart;
        }

        @Override
        public int compare(TypeBinding o1, TypeBinding o2) {
            int pos1 = TypeBindingComparator.getSourcePosition(o1);
            int pos2 = TypeBindingComparator.getSourcePosition(o2);
            return Integer.compare(pos1, pos2);
        }
    }
}

