/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.compiler.lookup;

import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.core.infer.InferredType;
import org.eclipse.wst.jsdt.internal.compiler.lookup.CompilationUnitScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.wst.jsdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.wst.jsdt.internal.compiler.lookup.UnresolvedReferenceBinding;

public final class ArrayBinding
extends ReferenceBinding {
    public static final FieldBinding ArrayLength = new FieldBinding(TypeConstants.LENGTH, (TypeBinding)TypeBinding.INT, 17, null);
    public TypeBinding leafComponentType;
    public int dimensions;
    LookupEnvironment environment;
    char[] constantPoolName;
    char[] genericTypeSignature;
    ReferenceBinding referenceBinding;

    public ArrayBinding(TypeBinding type, int dimensions, LookupEnvironment environment) {
        this.tagBits |= 1L;
        this.leafComponentType = type;
        this.dimensions = dimensions;
        this.environment = environment;
        if (type instanceof UnresolvedReferenceBinding) {
            ((UnresolvedReferenceBinding)type).addWrapper(this, environment);
        }
        this.referenceBinding = environment.getResolvedType(TypeConstants.ARRAY, null);
        this.fPackage = environment.defaultPackage;
    }

    @Override
    public char[] computeUniqueKey(boolean isLeaf) {
        char[] brackets = new char[this.dimensions];
        int i = this.dimensions - 1;
        while (i >= 0) {
            brackets[i] = 91;
            --i;
        }
        return CharOperation.concat(brackets, this.leafComponentType.computeUniqueKey(isLeaf));
    }

    @Override
    public char[] constantPoolName() {
        if (this.constantPoolName != null) {
            return this.constantPoolName;
        }
        char[] brackets = new char[this.dimensions];
        int i = this.dimensions - 1;
        while (i >= 0) {
            brackets[i] = 91;
            --i;
        }
        this.constantPoolName = CharOperation.concat(brackets, this.leafComponentType.signature());
        return this.constantPoolName;
    }

    @Override
    public char[] signature() {
        this.signature = CharOperation.concat('L', InferredType.ARRAY_NAME, ';');
        return this.signature;
    }

    @Override
    public String debugName() {
        StringBuffer brackets = new StringBuffer(this.dimensions * 2);
        int i = this.dimensions;
        while (--i >= 0) {
            brackets.append("[]");
        }
        return String.valueOf(this.leafComponentType.debugName()) + brackets.toString();
    }

    @Override
    public int dimensions() {
        return this.dimensions;
    }

    public TypeBinding elementsType() {
        if (this.dimensions == 1) {
            return this.leafComponentType;
        }
        return this.environment.createArrayType(this.leafComponentType, this.dimensions - 1);
    }

    public LookupEnvironment environment() {
        return this.environment;
    }

    public char[] genericTypeSignature() {
        if (this.genericTypeSignature == null) {
            char[] brackets = new char[this.dimensions];
            int i = this.dimensions - 1;
            while (i >= 0) {
                brackets[i] = 91;
                --i;
            }
            this.genericTypeSignature = CharOperation.concat(brackets, this.leafComponentType.signature());
        }
        return this.genericTypeSignature;
    }

    @Override
    public PackageBinding getPackage() {
        return this.leafComponentType.getPackage();
    }

    @Override
    public int hashCode() {
        return this.leafComponentType == null ? super.hashCode() : this.leafComponentType.hashCode();
    }

    @Override
    public boolean isCompatibleWith(TypeBinding otherType) {
        if (this == otherType) {
            return true;
        }
        switch (otherType.kind()) {
            case 68: {
                ArrayBinding otherArray = (ArrayBinding)otherType;
                return this.leafComponentType.isCompatibleWith(otherArray.leafComponentType);
            }
            case 132: {
                return otherType.isAnyType();
            }
            case 4: {
                return otherType == this.referenceBinding;
            }
        }
        switch (otherType.leafComponentType().id) {
            case 1: {
                return true;
            }
        }
        return false;
    }

    @Override
    public int kind() {
        return 68;
    }

    @Override
    public TypeBinding leafComponentType() {
        return this.leafComponentType;
    }

    @Override
    public int problemId() {
        return this.leafComponentType.problemId();
    }

    @Override
    public char[] qualifiedSourceName() {
        char[] brackets = new char[this.dimensions * 2];
        int i = this.dimensions * 2 - 1;
        while (i >= 0) {
            brackets[i] = 93;
            brackets[i - 1] = 91;
            i -= 2;
        }
        return CharOperation.concat(this.leafComponentType.qualifiedSourceName(), brackets);
    }

    @Override
    public char[] readableName() {
        char[] brackets = new char[this.dimensions * 2];
        int i = this.dimensions * 2 - 1;
        while (i >= 0) {
            brackets[i] = 93;
            brackets[i - 1] = 91;
            i -= 2;
        }
        return CharOperation.concat(this.leafComponentType.readableName(), brackets);
    }

    @Override
    public char[] shortReadableName() {
        char[] brackets = new char[this.dimensions * 2];
        int i = this.dimensions * 2 - 1;
        while (i >= 0) {
            brackets[i] = 93;
            brackets[i - 1] = 91;
            i -= 2;
        }
        return CharOperation.concat(this.leafComponentType.shortReadableName(), brackets);
    }

    @Override
    public char[] sourceName() {
        char[] brackets = new char[this.dimensions * 2];
        int i = this.dimensions * 2 - 1;
        while (i >= 0) {
            brackets[i] = 93;
            brackets[i - 1] = 91;
            i -= 2;
        }
        return CharOperation.concat(this.leafComponentType.sourceName(), brackets);
    }

    @Override
    public ReferenceBinding getSuperBinding() {
        if (this.referenceBinding != null) {
            return this.referenceBinding.getSuperBinding();
        }
        return null;
    }

    @Override
    public void swapUnresolved(UnresolvedReferenceBinding unresolvedType, ReferenceBinding resolvedType, LookupEnvironment env) {
        if (this.leafComponentType == unresolvedType) {
            this.leafComponentType = resolvedType;
            this.tagBits |= this.leafComponentType.tagBits;
        }
    }

    public String toString() {
        return this.leafComponentType != null ? this.debugName() : "NULL TYPE ARRAY";
    }

    @Override
    public FieldBinding[] availableFields() {
        if (this.referenceBinding != null) {
            return this.referenceBinding.availableFields();
        }
        return new FieldBinding[0];
    }

    @Override
    public MethodBinding[] availableMethods() {
        if (this.referenceBinding != null) {
            return this.referenceBinding.availableMethods();
        }
        return new MethodBinding[0];
    }

    @Override
    public int fieldCount() {
        if (this.referenceBinding != null) {
            return this.referenceBinding.fieldCount();
        }
        return 0;
    }

    @Override
    public FieldBinding[] fields() {
        if (this.referenceBinding != null) {
            return this.referenceBinding.fields();
        }
        return new FieldBinding[0];
    }

    @Override
    public InferredType getInferredType() {
        if (this.referenceBinding != null) {
            return this.referenceBinding.getInferredType();
        }
        return null;
    }

    @Override
    public MethodBinding[] getMethods(char[] selector) {
        if (this.referenceBinding != null) {
            return this.referenceBinding.getMethods(selector);
        }
        return new MethodBinding[0];
    }

    @Override
    boolean implementsMethod(MethodBinding method) {
        if (this.referenceBinding != null) {
            return this.referenceBinding.implementsMethod(method);
        }
        return false;
    }

    @Override
    public MethodBinding[] methods() {
        if (this.referenceBinding != null) {
            return this.referenceBinding.methods();
        }
        return new MethodBinding[0];
    }

    @Override
    public MethodBinding getExactMethod(char[] selector, TypeBinding[] argumentTypes, CompilationUnitScope refScope) {
        if (this.referenceBinding != null) {
            return this.referenceBinding.getExactMethod(selector, argumentTypes, refScope);
        }
        return null;
    }

    @Override
    public FieldBinding getField(char[] fieldName, boolean needResolve) {
        if (this.referenceBinding != null) {
            return this.referenceBinding.getField(fieldName, needResolve);
        }
        return null;
    }
}

