/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdi.internal;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Map;

public class ValueCache {
    private final Map<Object, SoftReference<Object>> cacheTable = new Hashtable<Object, SoftReference<Object>>();
    private final Map<SoftReference<Object>, Object> refTable = new Hashtable<SoftReference<Object>, Object>();
    private final ReferenceQueue<Object> refQueue = new ReferenceQueue();

    private void cleanup() {
        Reference<Object> ref;
        while ((ref = this.refQueue.poll()) != null) {
            Object key = this.refTable.get(ref);
            if (key != null) {
                this.cacheTable.remove(key);
            }
            this.refTable.remove(ref);
        }
    }

    public void put(Object key, Object value) {
        this.cleanup();
        SoftReference<Object> ref = new SoftReference<Object>(value, this.refQueue);
        this.cacheTable.put(key, ref);
        this.refTable.put(ref, key);
    }

    public Object get(Object key) {
        this.cleanup();
        Object value = null;
        SoftReference<Object> ref = this.cacheTable.get(key);
        if (ref != null) {
            value = ref.get();
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Object> values() {
        this.cleanup();
        ArrayList<Object> returnValues = new ArrayList<Object>();
        Map<Object, SoftReference<Object>> map = this.cacheTable;
        synchronized (map) {
            for (SoftReference<Object> ref : this.cacheTable.values()) {
                Object value = ref.get();
                if (value == null) continue;
                returnValues.add(value);
            }
        }
        return returnValues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Object> valuesWithType(Class<?> type) {
        this.cleanup();
        ArrayList<Object> returnValues = new ArrayList<Object>();
        Map<Object, SoftReference<Object>> map = this.cacheTable;
        synchronized (map) {
            for (SoftReference<Object> ref : this.cacheTable.values()) {
                Object value = ref.get();
                if (value == null || !value.getClass().equals(type)) continue;
                returnValues.add(value);
            }
        }
        return returnValues;
    }

    public Object remove(Object key) {
        this.cleanup();
        Object value = null;
        SoftReference<Object> ref = this.cacheTable.get(key);
        if (ref != null) {
            value = ref.get();
            this.refTable.remove(ref);
        }
        this.cacheTable.remove(key);
        return value;
    }
}

