/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.params.shadow.de.siegmar.fastcsv.reader;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import org.junit.jupiter.params.shadow.de.siegmar.fastcsv.reader.BomInputStream;
import org.junit.jupiter.params.shadow.de.siegmar.fastcsv.util.Nullable;

final class BomInputStreamReader
extends Reader {
    private final InputStream inputStream;
    private final Charset defaultCharset;
    @Nullable
    private Reader reader;

    BomInputStreamReader(InputStream inputStream, Charset defaultCharset) {
        this.inputStream = inputStream;
        this.defaultCharset = defaultCharset;
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        if (this.reader == null) {
            BomInputStream bomIn = new BomInputStream(this.inputStream, this.defaultCharset);
            this.reader = new InputStreamReader((InputStream)bomIn, bomIn.getCharset());
        }
        return this.reader.read(cbuf, off, len);
    }

    @Override
    public void close() throws IOException {
        this.inputStream.close();
    }
}

