/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.commit;

import java.text.MessageFormat;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.commit.NoteDetailsPage;
import org.eclipse.egit.ui.internal.commit.RepositoryCommit;
import org.eclipse.egit.ui.internal.commit.RepositoryCommitNote;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.forms.DetailsPart;
import org.eclipse.ui.forms.IDetailsPageProvider;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.MasterDetailsBlock;
import org.eclipse.ui.forms.SectionPart;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class NotesBlock
extends MasterDetailsBlock {
    private RepositoryCommit commit;
    private IManagedForm form;
    private IFormPart part;
    private TableViewer refsViewer;

    public NotesBlock(RepositoryCommit commit) {
        this.commit = commit;
    }

    public void createContent(IManagedForm managedForm, Composite parent) {
        super.createContent(managedForm, parent);
        this.sashForm.setWeights(new int[]{25, 75});
    }

    protected void createMasterPart(final IManagedForm managedForm, Composite parent) {
        this.form = managedForm;
        FormToolkit toolkit = managedForm.getToolkit();
        Composite masterArea = toolkit.createComposite(parent);
        GridLayoutFactory.swtDefaults().applyTo(masterArea);
        RepositoryCommitNote[] notes = this.commit.getNotes();
        Section refsSection = toolkit.createSection(masterArea, 256);
        refsSection.setText(MessageFormat.format(UIText.NotesBlock_NotesSection, notes.length));
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)refsSection);
        Composite refsArea = toolkit.createComposite((Composite)refsSection);
        refsSection.setClient((Control)refsArea);
        GridLayoutFactory.fillDefaults().extendedMargins(2, 2, 2, 2).applyTo(refsArea);
        toolkit.paintBordersFor(refsArea);
        Table refsTable = toolkit.createTable(refsArea, 772);
        this.refsViewer = new TableViewer(refsTable);
        this.refsViewer.setComparator(new ViewerComparator());
        refsTable.setData("FormWidgetFactory.drawBorder", (Object)"treeBorder");
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)refsTable);
        this.refsViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.refsViewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        this.refsViewer.setInput((Object)notes);
        this.part = new SectionPart(refsSection);
        this.refsViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                managedForm.fireSelectionChanged(NotesBlock.this.part, event.getSelection());
            }
        });
    }

    protected void registerPages(DetailsPart dPart) {
        dPart.setPageProvider((IDetailsPageProvider)new NoteDetailsPage());
    }

    protected void createToolBarActions(IManagedForm managedForm) {
    }

    public void selectFirstNote() {
        if (this.refsViewer.getTable().getItemCount() > 0) {
            this.refsViewer.getTable().setSelection(0);
            this.form.fireSelectionChanged(this.part, this.refsViewer.getSelection());
        }
    }
}

