/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.search;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;

public class PluginSearchScope {
    public static final int SCOPE_WORKSPACE = 0;
    public static final int SCOPE_SELECTION = 1;
    public static final int SCOPE_WORKING_SETS = 2;
    public static final int EXTERNAL_SCOPE_NONE = 0;
    public static final int EXTERNAL_SCOPE_ENABLED = 1;
    public static final int EXTERNAL_SCOPE_ALL = 2;
    private final int workspaceScope;
    private final int externalScope;
    private final Set<IResource> selectedResources;

    public PluginSearchScope(int workspaceScope, int externalScope, Set<IResource> selectedResources) {
        this.workspaceScope = workspaceScope;
        this.externalScope = externalScope;
        this.selectedResources = selectedResources;
    }

    public PluginSearchScope() {
        this(0, 1, null);
    }

    protected final void addExternalModel(IPluginModelBase candidate, ArrayList<IPluginModelBase> result) {
        if (this.externalScope == 2) {
            result.add(candidate);
        } else if (this.externalScope == 1 && candidate.isEnabled()) {
            result.add(candidate);
        }
    }

    protected final void addExternalModel(IFeatureModel candidate, List<IFeatureModel> result) {
        if (this.externalScope == 2) {
            result.add(candidate);
        } else if (this.externalScope == 1 && candidate.isEnabled()) {
            result.add(candidate);
        }
    }

    protected final void addWorkspaceModel(IPluginModelBase candidate, ArrayList<IPluginModelBase> result) {
        if (this.workspaceScope == 0) {
            result.add(candidate);
        } else if (this.selectedResources.contains(candidate.getUnderlyingResource().getProject())) {
            result.add(candidate);
        }
    }

    protected final void addWorkspaceModel(IFeatureModel candidate, List<IFeatureModel> result) {
        if (this.workspaceScope == 0) {
            result.add(candidate);
        } else if (this.selectedResources.contains(candidate.getUnderlyingResource().getProject())) {
            result.add(candidate);
        }
    }

    public IPluginModelBase[] getMatchingModels() {
        return this.addRelevantModels(PluginRegistry.getAllModels());
    }

    protected final IPluginModelBase[] addRelevantModels(IPluginModelBase[] models) {
        ArrayList<IPluginModelBase> result = new ArrayList<IPluginModelBase>();
        IPluginModelBase[] iPluginModelBaseArray = models;
        int n = models.length;
        int n2 = 0;
        while (n2 < n) {
            IPluginModelBase model = iPluginModelBaseArray[n2];
            if (model.getUnderlyingResource() != null) {
                this.addWorkspaceModel(model, result);
            } else {
                this.addExternalModel(model, result);
            }
            ++n2;
        }
        return result.toArray(new IPluginModelBase[result.size()]);
    }

    public IFeatureModel[] getMatchingFeatureModels() {
        return this.addRelevantModels(PDECore.getDefault().getFeatureModelManager().getModels());
    }

    protected final IFeatureModel[] addRelevantModels(IFeatureModel[] models) {
        ArrayList<IFeatureModel> result = new ArrayList<IFeatureModel>();
        IFeatureModel[] iFeatureModelArray = models;
        int n = models.length;
        int n2 = 0;
        while (n2 < n) {
            IFeatureModel model = iFeatureModelArray[n2];
            if (model.getUnderlyingResource() != null) {
                this.addWorkspaceModel(model, result);
            } else {
                this.addExternalModel(model, result);
            }
            ++n2;
        }
        return result.toArray(new IFeatureModel[result.size()]);
    }
}

