/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eclemma.internal.ui;

import java.net.URL;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.eclemma.core.CoverageTools;
import org.eclipse.eclemma.core.ICorePreferences;
import org.eclipse.eclemma.core.ICoverageSession;
import org.eclipse.eclemma.core.ISessionListener;
import org.eclipse.eclemma.internal.ui.UIPreferences;
import org.eclipse.eclemma.internal.ui.annotation.EditorTracker;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class EclEmmaUIPlugin
extends AbstractUIPlugin {
    public static final String ID = "org.eclipse.eclemma.ui";
    public static final String ID_COVERAGE_LAUNCH_GROUP = "org.eclipse.eclemma.ui.launchGroup.coverage";
    public static final String ELCL_SESSION = "icons/full/elcl16/session.png";
    public static final String ELCL_DUMP = "icons/full/elcl16/dump.png";
    public static final String EVIEW_COVERAGE = "icons/full/eview16/coverage.png";
    public static final String EVIEW_EXEC = "icons/full/eview16/exec.png";
    public static final String OBJ_SESSION = "icons/full/elcl16/session.png";
    public static final String OBJ_MARKERFULL = "icons/full/obj16/markerfull.png";
    public static final String OBJ_MARKERNO = "icons/full/obj16/markerno.png";
    public static final String OBJ_MARKERPARTIAL = "icons/full/obj16/markerpartial.png";
    private static final String[] OBJ_COVERAGE_OVERLAY = new String[]{"icons/full/ovr16/coverage00.png", "icons/full/ovr16/coverage01.png", "icons/full/ovr16/coverage02.png", "icons/full/ovr16/coverage03.png", "icons/full/ovr16/coverage04.png", "icons/full/ovr16/coverage05.png", "icons/full/ovr16/coverage06.png", "icons/full/ovr16/coverage07.png"};
    public static final String WIZBAN_EXPORT_SESSION = "icons/full/wizban/export_session.png";
    public static final String WIZBAN_IMPORT_SESSION = "icons/full/wizban/import_session.png";
    public static final String DGM_REDBAR = "icons/full/dgm/redbar.png";
    public static final String DGM_GREENBAR = "icons/full/dgm/greenbar.png";
    private static EclEmmaUIPlugin instance;
    private EditorTracker editorTracker;
    private ISessionListener sessionListener = new ISessionListener(){

        public void sessionAdded(ICoverageSession addedSession) {
            if (EclEmmaUIPlugin.this.getPreferenceStore().getBoolean("org.eclipse.eclemma.ui.show_coverage_view")) {
                EclEmmaUIPlugin.this.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        EclEmmaUIPlugin.this.showCoverageView();
                    }
                });
            }
        }

        public void sessionRemoved(ICoverageSession removedSession) {
        }

        public void sessionActivated(ICoverageSession session) {
        }
    };

    public void start(BundleContext context) throws Exception {
        super.start(context);
        CoverageTools.setPreferences((ICorePreferences)UIPreferences.CORE_PREFERENCES);
        CoverageTools.getSessionManager().addSessionListener(this.sessionListener);
        this.editorTracker = new EditorTracker(this.getWorkbench());
        instance = this;
    }

    public void stop(BundleContext context) throws Exception {
        instance = null;
        this.editorTracker.dispose();
        CoverageTools.getSessionManager().removeSessionListener(this.sessionListener);
        super.stop(context);
    }

    public static EclEmmaUIPlugin getInstance() {
        return instance;
    }

    private void showCoverageView() {
        IWorkbenchWindow window = this.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return;
        }
        IWorkbenchPage page = window.getActivePage();
        if (page != null) {
            try {
                IViewPart view = page.showView("org.eclipse.eclemma.ui.CoverageView", null, 3);
                page.bringToTop((IWorkbenchPart)view);
            }
            catch (PartInitException e) {
                EclEmmaUIPlugin.log(e);
            }
        }
    }

    public Shell getShell() {
        return this.getWorkbench().getActiveWorkbenchWindow().getShell();
    }

    public static IStatus errorStatus(String message, Throwable t) {
        return new Status(4, ID, 4, message, t);
    }

    public static void log(Throwable t) {
        String message = t.getMessage();
        if (message == null) {
            message = "Internal Error";
        }
        instance.getLog().log(EclEmmaUIPlugin.errorStatus(message, t));
    }

    public static ImageDescriptor getImageDescriptor(String key) {
        return EclEmmaUIPlugin.loadImage(key).getDescriptor(key);
    }

    public static Image getImage(String key) {
        return EclEmmaUIPlugin.loadImage(key).get(key);
    }

    public static ImageDescriptor getCoverageOverlay(double ratio) {
        int idx = (int)Math.round(ratio * (double)OBJ_COVERAGE_OVERLAY.length);
        if (idx < 0) {
            idx = 0;
        }
        if (idx >= OBJ_COVERAGE_OVERLAY.length) {
            idx = OBJ_COVERAGE_OVERLAY.length - 1;
        }
        return EclEmmaUIPlugin.getImageDescriptor(OBJ_COVERAGE_OVERLAY[idx]);
    }

    private static ImageRegistry loadImage(String path) {
        ImageRegistry reg = EclEmmaUIPlugin.getInstance().getImageRegistry();
        if (reg.getDescriptor(path) == null) {
            URL url = instance.getBundle().getEntry(path);
            reg.put(path, ImageDescriptor.createFromURL((URL)url));
        }
        return reg;
    }
}

