/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.dom;

import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.dom.DOMDocumentType;
import org.eclipse.lemminx.dom.DOMRange;
import org.eclipse.lemminx.dom.DTDDeclNode;
import org.eclipse.lemminx.dom.TargetRange;
import org.eclipse.lemminx.utils.XMLPositionUtility;
import org.eclipse.lsp4j.Range;

public class DTDDeclParameter
implements DOMRange,
TargetRange {
    private final DTDDeclNode ownerNode;
    String parameter;
    int start;
    int end;

    public DTDDeclParameter(DTDDeclNode ownerNode, int start, int end) {
        this.ownerNode = ownerNode;
        this.start = start;
        this.end = end;
    }

    @Override
    public int getStart() {
        return this.start;
    }

    @Override
    public int getEnd() {
        return this.end;
    }

    @Override
    public DOMDocument getOwnerDocument() {
        return this.getOwnerNode().getOwnerDocument();
    }

    public DOMDocumentType getOwnerDocType() {
        return this.getOwnerNode().getOwnerDocType();
    }

    public DTDDeclNode getOwnerNode() {
        return this.ownerNode;
    }

    public String getParameter() {
        if (this.parameter == null) {
            this.parameter = this.getOwnerDocType().getSubstring(this.start, this.end);
        }
        return this.parameter;
    }

    public String getParameterWithoutFirstAndLastChar() {
        if (this.parameter == null) {
            this.parameter = this.getOwnerDocType().getSubstring(this.start + 1, this.end - 1);
        }
        return this.parameter;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DTDDeclParameter)) {
            return false;
        }
        DTDDeclParameter temp = (DTDDeclParameter)obj;
        return this.start == temp.start && this.end == temp.end;
    }

    @Override
    public Range getTargetRange() {
        return XMLPositionUtility.createRange(this);
    }

    @Override
    public String getTargetURI() {
        return this.getOwnerDocument().getDocumentURI();
    }
}

