/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.merge;

import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.merge.MergeInputMode;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class MergeModeDialog
extends Dialog {
    private MergeInputMode mode = MergeInputMode.MERGED_OURS;
    private Button dontAskAgain;

    public MergeModeDialog(Shell parentShell) {
        super(parentShell);
    }

    public MergeInputMode getMergeMode() {
        return this.mode;
    }

    protected Control createDialogArea(Composite parent) {
        Composite main = new Composite(parent, 0);
        main.setLayout((Layout)new GridLayout(1, false));
        Button useMerged = new Button(main, 16);
        useMerged.setText(UIText.MergeModeDialog_MergeMode_3_Label);
        useMerged.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MergeModeDialog.this.mode = MergeInputMode.MERGED_OURS;
            }
        });
        useMerged.setSelection(true);
        Button useWorkspace = new Button(main, 16);
        useWorkspace.setText(UIText.MergeModeDialog_MergeMode_1_Label);
        useWorkspace.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MergeModeDialog.this.mode = MergeInputMode.WORKTREE;
            }
        });
        useWorkspace.setSelection(false);
        Button useHead = new Button(main, 16);
        useHead.setText(UIText.MergeModeDialog_MergeMode_2_Label);
        useHead.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MergeModeDialog.this.mode = MergeInputMode.STAGE_2;
            }
        });
        useHead.setSelection(false);
        this.dontAskAgain = new Button(main, 32);
        this.dontAskAgain.setText(UIText.MergeModeDialog_DontAskAgainLabel);
        return main;
    }

    protected void okPressed() {
        boolean save = this.dontAskAgain.getSelection();
        super.okPressed();
        if (save) {
            int value = this.mode.toInteger();
            IPreferenceStore store = Activator.getDefault().getPreferenceStore();
            store.setValue("merge_mode", value);
        }
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(UIText.MergeModeDialog_DialogTitle);
    }
}

