"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getComponentType = getComponentType;
exports.getSelfComponentName = getSelfComponentName;
exports.getVariableType = getVariableType;
const shared_1 = require("@vue/shared");
const path = require("path-browserify");
function getComponentType(ts, program, fileName, components, tag) {
    const checker = program.getTypeChecker();
    const name = tag.split('.');
    let componentSymbol = components.type.getProperty(name[0])
        ?? components.type.getProperty((0, shared_1.camelize)(name[0]))
        ?? components.type.getProperty((0, shared_1.capitalize)((0, shared_1.camelize)(name[0])));
    let componentType;
    if (!componentSymbol) {
        const name = getSelfComponentName(fileName);
        if (name === (0, shared_1.capitalize)((0, shared_1.camelize)(tag))) {
            componentType = getVariableType(ts, program, fileName, '__VLS_export')?.type;
        }
    }
    else {
        componentType = checker.getTypeOfSymbolAtLocation(componentSymbol, components.node);
        for (let i = 1; i < name.length; i++) {
            componentSymbol = componentType.getProperty(name[i]);
            if (componentSymbol) {
                componentType = checker.getTypeOfSymbolAtLocation(componentSymbol, components.node);
            }
        }
    }
    return componentType;
}
function getSelfComponentName(fileName) {
    const baseName = path.basename(fileName);
    return (0, shared_1.capitalize)((0, shared_1.camelize)(baseName.slice(0, baseName.lastIndexOf('.'))));
}
function getVariableType(ts, program, fileName, name) {
    const tsSourceFile = program.getSourceFile(fileName);
    if (tsSourceFile) {
        const checker = program.getTypeChecker();
        const node = searchVariableDeclarationNode(ts, tsSourceFile, name);
        if (node) {
            return {
                node: node,
                type: checker.getTypeAtLocation(node),
            };
        }
    }
}
function searchVariableDeclarationNode(ts, sourceFile, name) {
    let result;
    walk(sourceFile);
    return result;
    function walk(node) {
        if (result) {
            return;
        }
        else if (ts.isVariableDeclaration(node) && node.name.getText() === name) {
            result = node;
        }
        else {
            node.forEachChild(walk);
        }
    }
}
//# sourceMappingURL=utils.js.map