/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.server.ui;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class Activator
extends AbstractUIPlugin
implements ISelectionListener {
    public static final String PLUGIN_ID = "org.eclipse.php.server.ui";
    public static final boolean isDebugMode;
    public static IStructuredSelection currentSelection;
    private static Activator plugin;

    static {
        String value = Platform.getDebugOption((String)"org.eclipse.php.server.ui/debug");
        isDebugMode = value != null && value.equalsIgnoreCase("true");
    }

    public Activator() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        final IWorkbench workbench = this.getWorkbench();
        workbench.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchWindow iww = workbench.getActiveWorkbenchWindow();
                if (iww != null) {
                    ISelectionService iss = iww.getSelectionService();
                    ISelection s = iss.getSelection();
                    if (s instanceof IStructuredSelection) {
                        currentSelection = (IStructuredSelection)s;
                    }
                    iss.addSelectionListener((ISelectionListener)Activator.this);
                }
            }
        });
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            currentSelection = (IStructuredSelection)selection;
        }
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }

    public Image getImage(String path) {
        Image image = this.getImageRegistry().get(path);
        if (image == null) {
            this.getImageRegistry().put(path, this.getImageDescriptor(path));
            image = this.getImageRegistry().get(path);
        }
        return image;
    }

    public ImageDescriptor getImageDescriptor(String path) {
        ImageDescriptor descriptor = this.getImageRegistry().getDescriptor(path);
        if (descriptor == null) {
            this.getImageRegistry().put(path, Activator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path));
            descriptor = this.getImageRegistry().getDescriptor(path);
        }
        return descriptor;
    }

    public static void logError(Throwable e) {
        Activator.getDefault().getLog().log((IStatus)new Status(4, PLUGIN_ID, e.getMessage(), e));
    }
}

