/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.ui.launching;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.php.internal.debug.ui.Logger;
import org.eclipse.php.internal.debug.ui.PHPDebugUIPlugin;
import org.eclipse.php.internal.debug.ui.launching.IDebuggerLaunchSettingsSection;

public class DebuggerLaunchSettingsSectionRegistry {
    private static List<Entry> entries;
    private static final String PROP_ID = "id";
    private static final String PROP_OVERRIDES = "overrides";
    private static final String PROP_DEBUGGER_ID = "debuggerId";
    private static final String PROP_LAUNCH_TYPE_ID = "launchTypeId";
    private static final String PROP_SECTION = "section";
    public static final String EXTENSION_POINT_ID;
    private static DebuggerLaunchSettingsSectionRegistry instance;

    static {
        EXTENSION_POINT_ID = PHPDebugUIPlugin.getDefault().getBundle().getSymbolicName() + ".phpDebuggerLaunchSettingsSections";
    }

    private static final List<Entry> getEntries() {
        if (entries == null) {
            entries = DebuggerLaunchSettingsSectionRegistry.getDefault().readFromExtensionPoint();
        }
        return entries;
    }

    public static final IDebuggerLaunchSettingsSection getSection(String debuggerId, String launchTypeId) {
        for (Entry entry : DebuggerLaunchSettingsSectionRegistry.getEntries()) {
            if (!entry.debuggerId.equals(debuggerId) || !entry.launchTypeId.equals(launchTypeId)) continue;
            IDebuggerLaunchSettingsSection settingsSection = null;
            try {
                settingsSection = (IDebuggerLaunchSettingsSection)DebuggerLaunchSettingsSectionRegistry.createInstance(entry.element, PROP_SECTION, IDebuggerLaunchSettingsSection.class);
            }
            catch (CoreException e) {
                Logger.logException("Could not instantiate debugger launch settings section from extension point data.", e);
            }
            return settingsSection;
        }
        return null;
    }

    private static DebuggerLaunchSettingsSectionRegistry getDefault() {
        if (instance == null) {
            instance = new DebuggerLaunchSettingsSectionRegistry();
        }
        return instance;
    }

    private List<Entry> readFromExtensionPoint() {
        IConfigurationElement[] configurationElements;
        ArrayList<Entry> entries = new ArrayList<Entry>();
        IConfigurationElement[] iConfigurationElementArray = configurationElements = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_POINT_ID);
        int n = configurationElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            String id = element.getAttribute(PROP_ID);
            String overridenSectionId = element.getAttribute(PROP_OVERRIDES);
            String debuggerId = element.getAttribute(PROP_DEBUGGER_ID);
            String launchTypeId = element.getAttribute(PROP_LAUNCH_TYPE_ID);
            entries.add(new Entry(element, id, overridenSectionId, debuggerId, launchTypeId));
            ++n2;
        }
        return this.filterEntries(entries);
    }

    private static Object createInstance(IConfigurationElement element, String propertyName, Class instanceClass) throws CoreException {
        Object object = element.createExecutableExtension(propertyName);
        if (!instanceClass.isAssignableFrom(object.getClass())) {
            String message = String.format("Invalid typecast for %s", element.getAttribute(propertyName));
            Status status = new Status(4, PHPDebugUIPlugin.getDefault().getBundle().getSymbolicName(), message);
            throw new CoreException((IStatus)status);
        }
        return object;
    }

    private List<Entry> filterEntries(List<Entry> entries) {
        ArrayList<Entry> topHierarchyEntries = new ArrayList<Entry>();
        for (Entry entryToCheck : entries) {
            boolean isTopHierarchy = true;
            for (Entry entry : entries) {
                if (!entryToCheck.id.equals(entry.overridenSectionId)) continue;
                isTopHierarchy = false;
                break;
            }
            if (!isTopHierarchy) continue;
            topHierarchyEntries.add(entryToCheck);
        }
        return topHierarchyEntries;
    }

    private class Entry {
        IConfigurationElement element;
        String id;
        String overridenSectionId;
        String debuggerId;
        String launchTypeId;

        public Entry(IConfigurationElement element, String id, String overridenSectionId, String debuggerId, String launchTypeId) {
            this.element = element;
            this.id = id;
            this.debuggerId = debuggerId;
            this.launchTypeId = launchTypeId;
            this.overridenSectionId = overridenSectionId;
        }
    }
}

