/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.terminal.view.ui.streams;

import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.core.runtime.Assert;
import org.eclipse.terminal.connector.ISettingsStore;
import org.eclipse.terminal.connector.InMemorySettingsStore;
import org.eclipse.terminal.view.core.ITerminalServiceOutputStreamMonitorListener;

public class StreamsSettings {
    private OutputStream stdin;
    private InputStream stdout;
    private InputStream stderr;
    private boolean localEcho = true;
    private String lineSeparator = null;
    private ITerminalServiceOutputStreamMonitorListener[] stdoutListeners = null;
    private ITerminalServiceOutputStreamMonitorListener[] stderrListeners = null;

    public void setStdinStream(OutputStream stdin) {
        this.stdin = stdin;
    }

    public OutputStream getStdinStream() {
        return this.stdin;
    }

    public void setStdoutStream(InputStream stdout) {
        this.stdout = stdout;
    }

    public InputStream getStdoutStream() {
        return this.stdout;
    }

    public void setStderrStream(InputStream stderr) {
        this.stderr = stderr;
    }

    public InputStream getStderrStream() {
        return this.stderr;
    }

    public void setLocalEcho(boolean value) {
        this.localEcho = value;
    }

    public boolean isLocalEcho() {
        return this.localEcho;
    }

    public void setLineSeparator(String separator) {
        this.lineSeparator = separator;
    }

    public String getLineSeparator() {
        return this.lineSeparator;
    }

    public void setStdOutListeners(ITerminalServiceOutputStreamMonitorListener[] listeners) {
        this.stdoutListeners = listeners;
    }

    public ITerminalServiceOutputStreamMonitorListener[] getStdOutListeners() {
        return this.stdoutListeners;
    }

    public void setStdErrListeners(ITerminalServiceOutputStreamMonitorListener[] listeners) {
        this.stderrListeners = listeners;
    }

    public ITerminalServiceOutputStreamMonitorListener[] getStdErrListeners() {
        return this.stderrListeners;
    }

    public void load(ISettingsStore store) {
        Assert.isNotNull((Object)store);
        this.localEcho = Boolean.parseBoolean(store.get("LocalEcho", Boolean.FALSE.toString()));
        this.lineSeparator = store.get("LineSeparator", null);
        if (store instanceof InMemorySettingsStore) {
            this.stdin = (OutputStream)((InMemorySettingsStore)store).getSettings().get("stdin");
            this.stdout = (InputStream)((InMemorySettingsStore)store).getSettings().get("stdout");
            this.stderr = (InputStream)((InMemorySettingsStore)store).getSettings().get("stderr");
            this.stdoutListeners = (ITerminalServiceOutputStreamMonitorListener[])((InMemorySettingsStore)store).getSettings().get("StdOutListeners");
            this.stderrListeners = (ITerminalServiceOutputStreamMonitorListener[])((InMemorySettingsStore)store).getSettings().get("StdErrListeners");
        }
    }

    public void save(ISettingsStore store) {
        Assert.isNotNull((Object)store);
        store.put("LocalEcho", Boolean.toString(this.localEcho));
        store.put("LineSeparator", this.lineSeparator);
        if (store instanceof InMemorySettingsStore) {
            ((InMemorySettingsStore)store).getSettings().put("stdin", this.stdin);
            ((InMemorySettingsStore)store).getSettings().put("stdout", this.stdout);
            ((InMemorySettingsStore)store).getSettings().put("stderr", this.stderr);
            ((InMemorySettingsStore)store).getSettings().put("StdOutListeners", this.stdoutListeners);
            ((InMemorySettingsStore)store).getSettings().put("StdErrListeners", this.stderrListeners);
        }
    }
}

