/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.texteditor;

import java.util.ResourceBundle;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextEditorAction;

public class RecenterAction
extends TextEditorAction {
    private static final int RECENTER_MIDDLE = 0;
    private static final int RECENTER_TOP = 1;
    private static final int RECENTER_BOTTOM = 2;
    private static final int RECENTER_POS_SIZE = 3;
    private int fPrevOffset = -1;
    private int fDestPos;

    public RecenterAction(ResourceBundle bundle, String prefix, ITextEditor editor) {
        super(bundle, prefix, editor);
    }

    public void run() {
        ITextEditor editor = this.getTextEditor();
        if (!(editor instanceof AbstractTextEditor)) {
            return;
        }
        ISourceViewer viewer = ((AbstractTextEditor)editor).getSourceViewer();
        if (viewer == null) {
            return;
        }
        StyledText st = viewer.getTextWidget();
        if (st == null) {
            return;
        }
        int height = st.getClientArea().height;
        int lineHeight = st.getLineHeight();
        int rowsPerScreen = height / lineHeight;
        int caretOffset = st.getCaretOffset();
        int caretLine = st.getLineAtOffset(caretOffset);
        if (caretOffset == this.fPrevOffset) {
            ++this.fDestPos;
            this.fDestPos %= 3;
        } else {
            this.fDestPos = 0;
        }
        this.fPrevOffset = caretOffset;
        int line = 0;
        switch (this.fDestPos) {
            case 0: {
                line = Math.max(0, caretLine - rowsPerScreen / 2);
                break;
            }
            case 1: {
                line = caretLine;
                break;
            }
            case 2: {
                line = Math.max(0, caretLine - rowsPerScreen + 1);
                break;
            }
        }
        st.setTopIndex(line);
    }
}

