/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.project;

import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.php.internal.core.preferences.IPreferencesPropagatorListener;
import org.eclipse.php.internal.core.preferences.PreferencePropagatorFactory;
import org.eclipse.php.internal.core.preferences.PreferencesPropagator;
import org.eclipse.php.internal.core.preferences.PreferencesPropagatorEvent;
import org.eclipse.php.internal.core.preferences.PreferencesSupport;

public class PHPVersionChangedHandler
implements IResourceChangeListener {
    private HashMap<IProject, HashSet<IPreferencesPropagatorListener>> projectListeners = new HashMap();
    private HashMap<IProject, PreferencesPropagatorListener> preferencesPropagatorListeners = new HashMap();
    private PreferencesPropagator preferencesPropagator = PreferencePropagatorFactory.getPreferencePropagator("org.eclipse.php.core");
    private static final String NODES_QUALIFIER = "org.eclipse.php.core";
    private static final PHPVersionChangedHandler instance = new PHPVersionChangedHandler();

    private PHPVersionChangedHandler() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
    }

    public static PHPVersionChangedHandler getInstance() {
        return instance;
    }

    private void projectVersionChanged(IProject project, PreferencesPropagatorEvent event) {
        HashSet<IPreferencesPropagatorListener> listeners = this.projectListeners.get(project);
        if (listeners != null) {
            for (IPreferencesPropagatorListener listener : listeners) {
                listener.preferencesEventOccured(event);
            }
        }
    }

    public void addPHPVersionChangedListener(IPreferencesPropagatorListener listener) {
        IProject project = listener.getProject();
        HashSet<IPreferencesPropagatorListener> listeners = this.projectListeners.get(project);
        if (listeners == null) {
            this.projectAdded(project);
            listeners = this.projectListeners.get(project);
        }
        listeners.add(listener);
    }

    public void removePHPVersionChangedListener(IPreferencesPropagatorListener listener) {
        if (listener == null) {
            return;
        }
        IProject project = listener.getProject();
        HashSet<IPreferencesPropagatorListener> listeners = this.projectListeners.get(project);
        if (listeners != null) {
            listeners.remove(listener);
        }
    }

    public void projectAdded(IProject project) {
        if (project == null || this.projectListeners.get(project) != null) {
            return;
        }
        this.projectListeners.put(project, new HashSet());
        PreferencesPropagatorListener listener = new PreferencesPropagatorListener(project);
        this.preferencesPropagatorListeners.put(project, listener);
        this.preferencesPropagator.addPropagatorListener(listener, "phpVersion");
        this.preferencesPropagator.addPropagatorListener(listener, "useShortTags");
        this.preferencesPropagator.addPropagatorListener(listener, "use_asp_tags_as_php");
    }

    public void projectRemoved(IProject project) {
        PreferencesPropagatorListener listener = this.preferencesPropagatorListeners.get(project);
        if (listener == null) {
            return;
        }
        this.preferencesPropagator.removePropagatorListener(listener, "use_asp_tags_as_php");
        this.preferencesPropagator.removePropagatorListener(listener, "useShortTags");
        this.preferencesPropagator.removePropagatorListener(listener, "phpVersion");
        this.preferencesPropagatorListeners.remove(project);
        this.projectListeners.remove(project);
    }

    private void checkProjectsBeingAddedOrRemoved(IResourceDelta delta) {
        IResourceDelta[] children;
        block14: {
            if (delta == null) {
                return;
            }
            IResource resource = delta.getResource();
            children = null;
            block0 : switch (resource.getType()) {
                case 8: {
                    children = delta.getAffectedChildren();
                    break;
                }
                case 4: {
                    IProject project = (IProject)resource;
                    switch (delta.getKind()) {
                        case 1: {
                            this.projectAdded(project);
                            break block0;
                        }
                        case 4: {
                            if ((delta.getFlags() & 0x4000) != 0) {
                                if (project.isOpen()) {
                                    this.projectAdded(project);
                                    break block0;
                                }
                                this.projectRemoved(project);
                                break block0;
                            }
                            break block14;
                        }
                        case 2: {
                            this.projectRemoved(project);
                        }
                    }
                }
            }
        }
        if (children != null) {
            int i = 0;
            while (i < children.length) {
                this.checkProjectsBeingAddedOrRemoved(children[i]);
                ++i;
            }
        }
    }

    public void resourceChanged(IResourceChangeEvent event) {
        this.checkProjectsBeingAddedOrRemoved(event.getDelta());
    }

    private class PreferencesPropagatorListener
    implements IPreferencesPropagatorListener {
        private IProject project;

        public PreferencesPropagatorListener(IProject project) {
            this.project = project;
        }

        @Override
        public void preferencesEventOccured(PreferencesPropagatorEvent event) {
            String preferencesValue;
            if (event.getNewValue() == null) {
                String newValue = PreferencesSupport.getWorkspacePreferencesValue(PHPVersionChangedHandler.NODES_QUALIFIER, (String)event.getKey());
                if (newValue == null || newValue.equals(event.getOldValue())) {
                    return;
                }
                event = new PreferencesPropagatorEvent(event.getSource(), event.getOldValue(), newValue, event.getKey());
            } else if (event.getOldValue() == null && (preferencesValue = PreferencesSupport.getWorkspacePreferencesValue(PHPVersionChangedHandler.NODES_QUALIFIER, (String)event.getKey())) != null && preferencesValue.equals(event.getNewValue())) {
                return;
            }
            PHPVersionChangedHandler.this.projectVersionChanged(this.project, event);
        }

        @Override
        public IProject getProject() {
            return this.project;
        }
    }
}

