/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.codeassist.contexts;

import java.util.regex.Pattern;
import org.eclipse.dltk.annotations.NonNull;
import org.eclipse.dltk.annotations.Nullable;
import org.eclipse.dltk.core.CompletionRequestor;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.php.core.PHPVersion;
import org.eclipse.php.core.codeassist.ICompletionScope;
import org.eclipse.php.internal.core.codeassist.contexts.StatementContext;
import org.eclipse.php.internal.core.util.MagicMemberUtil;
import org.eclipse.php.internal.core.util.text.PHPTextSequenceUtilities;
import org.eclipse.php.internal.core.util.text.TextSequence;
import org.eclipse.wst.sse.core.internal.parser.ContextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;

public abstract class UseStatementContext
extends StatementContext {
    public static final String FUNCTION_KEYWORD = "function";
    public static final String CONST_KEYWORD = "const";
    public static final String USE_KEYWORD = "use";
    private static final Pattern USE_GROUP_SEPARATOR = Pattern.compile("[,]\\p{javaWhitespace}*");
    private TYPES type;
    private TextSequence rebuiltUseStatementText;
    private TextSequence longestPrefixTextBeforeCursor;
    private TextSequence biggestCommonStatementText;
    private boolean isCursorInsideGroupStatement;
    private boolean isUseFunctionStatement;
    private boolean isUseConstStatement;

    @Override
    public boolean isAbsolute() {
        return this.getType() != TYPES.TRAIT;
    }

    public boolean isUseFunctionStatement() {
        return this.isUseFunctionStatement;
    }

    public boolean isUseConstStatement() {
        return this.isUseConstStatement;
    }

    private boolean hasUsePrefix(TextSequence statementText) {
        return statementText.length() >= 4 && USE_KEYWORD.equalsIgnoreCase(statementText.subSequence(0, 3).toString()) && Character.isWhitespace(statementText.subSequence(3, 4).charAt(0));
    }

    private void findConstOrFunctionWord(TextSequence statementText, int wordIdx, boolean isAfterOpeningCurly) {
        String[] stringArray;
        if (isAfterOpeningCurly) {
            stringArray = USE_GROUP_SEPARATOR.split(statementText.toString(), -1);
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = statementText.toString();
        }
        String[] groupStatements = stringArray;
        String[] words = MagicMemberUtil.WHITESPACE_SEPERATOR.split(groupStatements[groupStatements.length - 1], -1);
        if (wordIdx >= words.length) {
            return;
        }
        if (wordIdx == words.length - 1) {
            return;
        }
        if (CONST_KEYWORD.equalsIgnoreCase(words[wordIdx])) {
            this.isUseConstStatement = true;
        } else if (FUNCTION_KEYWORD.equalsIgnoreCase(words[wordIdx])) {
            this.isUseFunctionStatement = true;
        }
    }

    private boolean buildUseStatement(int offset, @NonNull IStructuredDocumentRegion sdRegion) {
        TextSequence statementTextBeforeOpeningCurly;
        TextSequence statementText;
        ContextRegion[] foundDelimiter = new ContextRegion[1];
        this.longestPrefixTextBeforeCursor = this.rebuiltUseStatementText = (statementText = PHPTextSequenceUtilities.getStatement(offset, sdRegion, true, null, 0, foundDelimiter));
        this.biggestCommonStatementText = this.rebuiltUseStatementText;
        this.isUseConstStatement = false;
        this.isUseFunctionStatement = false;
        this.isCursorInsideGroupStatement = false;
        this.type = TYPES.NONE;
        ICompletionScope scope = this.getCompanion().getScope();
        switch (scope.getType()) {
            case USE: 
            case USE_CONST: 
            case USE_FUNCTION: {
                this.type = TYPES.USE;
                this.findConstOrFunctionWord(statementText, 1, false);
                if (!this.hasUsePrefix(statementText)) break;
                return true;
            }
            case USE_GROUP: {
                this.type = TYPES.USE_GROUP;
                this.isCursorInsideGroupStatement = true;
                break;
            }
            case TRAIT_USE: 
            case TRAIT_CONFLICT: {
                this.type = TYPES.TRAIT;
                return !this.getCompanion().getPHPVersion().isLessThan(PHPVersion.PHP5_4);
            }
            default: {
                return false;
            }
        }
        if (!this.getCompanion().getPHPVersion().isLessThan(PHPVersion.PHP7_0) && foundDelimiter[0] != null && foundDelimiter[0].getType() == "PHP_CURLY_OPEN" && foundDelimiter[0].getStart() >= 4 && this.hasUsePrefix(statementTextBeforeOpeningCurly = PHPTextSequenceUtilities.getStatement(foundDelimiter[0].getStart(), sdRegion, true))) {
            int idxS2;
            this.findConstOrFunctionWord(statementTextBeforeOpeningCurly, 1, false);
            this.findConstOrFunctionWord(statementText, 0, true);
            String s1 = statementTextBeforeOpeningCurly.toString();
            int endS1 = PHPTextSequenceUtilities.readBackwardSpaces(s1, s1.length());
            String s2 = statementText.toString();
            if (this.isUseFunctionStatement || this.isUseConstStatement) {
                int endS2 = s2.length();
                idxS2 = PHPTextSequenceUtilities.readNamespaceStartIndex(s2, endS2, false);
            } else {
                int endS2 = PHPTextSequenceUtilities.readBackwardSpaces(s2, s2.length());
                idxS2 = PHPTextSequenceUtilities.readNamespaceStartIndex(s2, endS2, false);
                if (idxS2 == endS2) {
                    idxS2 = endS2 = s2.length();
                }
            }
            int idx3 = idxS2;
            if (idxS2 < s2.length() && s2.charAt(idxS2) == '\\') {
                ++idxS2;
            }
            TextSequence fullStatementText = PHPTextSequenceUtilities.getStatement(offset, sdRegion, true, new String[]{"PHP_CURLY_OPEN"}, 1, null);
            fullStatementText = fullStatementText.cutTextSequence(endS1, fullStatementText.length() - (statementText.length() - idxS2));
            this.biggestCommonStatementText = statementTextBeforeOpeningCurly.cutTextSequence(endS1, statementTextBeforeOpeningCurly.length());
            this.longestPrefixTextBeforeCursor = statementText.cutTextSequence(0, idx3);
            this.rebuiltUseStatementText = fullStatementText;
            this.type = TYPES.USE_GROUP;
            this.isCursorInsideGroupStatement = true;
            return true;
        }
        return false;
    }

    public TYPES getType() {
        return this.type;
    }

    @Override
    @NonNull
    public TextSequence getStatementText() {
        return this.rebuiltUseStatementText;
    }

    @Nullable
    public String getGroupPrefixBeforeOpeningCurly() {
        if (!this.isCursorInsideGroupStatement) {
            return null;
        }
        int statementLength = this.biggestCommonStatementText.length();
        int prefixEnd = PHPTextSequenceUtilities.readBackwardSpaces(this.biggestCommonStatementText, statementLength);
        int prefixStart = PHPTextSequenceUtilities.readNamespaceStartIndex(this.biggestCommonStatementText, prefixEnd, true);
        return prefixStart < 0 ? "" : this.biggestCommonStatementText.subSequence(prefixStart, prefixEnd).toString();
    }

    @NonNull
    public String getPrefixBeforeCursor() {
        if (this.hasWhitespaceBeforeCursor()) {
            return "";
        }
        int statementLength = this.longestPrefixTextBeforeCursor.length();
        int prefixEnd = PHPTextSequenceUtilities.readBackwardSpaces(this.longestPrefixTextBeforeCursor, statementLength);
        int prefixStart = PHPTextSequenceUtilities.readIdentifierStartIndex(this.getCompanion().getPHPVersion(), this.longestPrefixTextBeforeCursor, prefixEnd, true);
        return prefixStart < 0 ? "" : this.longestPrefixTextBeforeCursor.subSequence(prefixStart, prefixEnd).toString();
    }

    @Override
    public int getReplacementStart() {
        return this.getCompanion().getOffset() - this.getPrefixBeforeCursor().length();
    }

    @Override
    public boolean isValid(@NonNull ISourceModule sourceModule, int offset, CompletionRequestor requestor) {
        if (!super.isValid(sourceModule, offset, requestor)) {
            return false;
        }
        return this.buildUseStatement(offset, this.getCompanion().getStructuredDocumentRegion());
    }

    public static enum TYPES {
        NONE,
        TRAIT,
        USE,
        USE_GROUP;

    }
}

