/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.compiler.ast.nodes;

import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.utils.CorePrinter;
import org.eclipse.php.internal.core.compiler.ast.visitor.ASTPrintVisitor;

public class UnaryOperation
extends Expression {
    public static final int OP_PLUS = 0;
    public static final int OP_MINUS = 1;
    public static final int OP_NOT = 2;
    public static final int OP_TILDA = 3;
    private final Expression expr;
    private final int operator;

    public UnaryOperation(int start, int end, Expression expr, int operator) {
        super(start, end);
        assert (expr != null);
        this.expr = expr;
        this.operator = operator;
    }

    public void traverse(ASTVisitor visitor) throws Exception {
        if (visitor.visit((Expression)this)) {
            this.expr.traverse(visitor);
            visitor.endvisit((Expression)this);
        }
    }

    public String getOperator() {
        switch (this.getOperatorType()) {
            case 0: {
                return "+";
            }
            case 1: {
                return "-";
            }
            case 2: {
                return "!";
            }
            case 3: {
                return "~";
            }
        }
        throw new IllegalArgumentException();
    }

    public int getKind() {
        return 59;
    }

    public Expression getExpr() {
        return this.expr;
    }

    public int getOperatorType() {
        return this.operator;
    }

    public final void printNode(CorePrinter output) {
    }

    public String toString() {
        return ASTPrintVisitor.toXMLString((ASTNode)this);
    }
}

