/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.compiler.problem;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.compiler.problem.IProblem;
import org.eclipse.dltk.compiler.problem.IProblemFactory;
import org.eclipse.dltk.compiler.problem.IProblemIdentifierExtension;
import org.eclipse.dltk.compiler.problem.IProblemSeverityTranslator;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IScriptProject;

public class DefaultProblemFactory
implements IProblemFactory {
    @Override
    public String getMarkerType(IProblem problem) {
        String markerType;
        if (problem.getID() instanceof IProblemIdentifierExtension && (markerType = ((IProblemIdentifierExtension)((Object)problem.getID())).getMarkerType()) != null) {
            return markerType;
        }
        return problem.isTask() ? this.getTaskMarkerType() : this.getProblemMarkerType();
    }

    protected String getProblemMarkerType() {
        return "org.eclipse.dltk.core.problem";
    }

    protected String getTaskMarkerType() {
        return "org.eclipse.dltk.core.task";
    }

    @Override
    public IMarker createMarker(IResource resource, IProblem problem) throws CoreException {
        String markerType = this.getMarkerType(problem);
        return resource.createMarker(markerType);
    }

    @Override
    public void deleteMarkers(IResource resource) throws CoreException {
        resource.deleteMarkers("org.eclipse.dltk.core.problem", true, 2);
        resource.deleteMarkers("org.eclipse.dltk.core.task", true, 2);
    }

    @Override
    public boolean isValidMarker(IMarker marker) {
        try {
            return marker.exists() && (marker.isSubtypeOf("org.eclipse.dltk.core.problem") || marker.isSubtypeOf("org.eclipse.dltk.core.task"));
        }
        catch (CoreException e) {
            DLTKCore.error(e);
            return false;
        }
    }

    protected boolean isValidMarkerType(String markerType) {
        return markerType.startsWith("org.eclipse.dltk");
    }

    @Override
    public IProblemSeverityTranslator createSeverityTranslator(IScriptProject project) {
        return IProblemSeverityTranslator.IDENTITY;
    }
}

