/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.debug.presentation;

import java.net.URI;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDisconnect;
import org.eclipse.debug.core.model.ILineBreakpoint;
import org.eclipse.debug.core.model.ITerminate;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.ISourcePresentation;
import org.eclipse.debug.ui.IValueDetailListener;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.lsp4e.debug.DSPPlugin;
import org.eclipse.lsp4e.debug.debugmodel.DSPDebugElement;
import org.eclipse.lsp4e.debug.debugmodel.DSPStackFrame;
import org.eclipse.lsp4e.debug.debugmodel.DSPThread;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;

public class DSPDebugModelPresentation
extends LabelProvider
implements IDebugModelPresentation,
IFontProvider {
    private @Nullable Font italic;

    public String getText(Object element) {
        DSPDebugElement debugElement;
        StringBuilder label = new StringBuilder();
        if (element instanceof DSPThread) {
            IDisconnect disconned;
            DSPThread thread = (DSPThread)((Object)element);
            label.append(NLS.bind((String)"Thread #{0} [{1}]", (Object)thread.getId(), (Object)thread.getName()));
            if (element instanceof ITerminate) {
                ITerminate terminate = (ITerminate)element;
                if (terminate.isTerminated()) {
                    label.insert(0, "<terminated>");
                }
            } else if (element instanceof IDisconnect && (disconned = (IDisconnect)element).isDisconnected()) {
                label.insert(0, "<disconnected>");
            }
        } else {
            String source;
            DSPStackFrame frame;
            int line;
            label.append(DebugUIPlugin.getDefaultLabelProvider().getText(element));
            if (element instanceof DSPStackFrame && (line = this.getLine(frame = (DSPStackFrame)((Object)element))) > 0 && (source = frame.getSourceName()) != null) {
                String suffix;
                String file = new Path(source).lastSegment();
                if (file == null) {
                    file = source;
                }
                if (!DSPDebugModelPresentation.endsWith(label, suffix = "(" + file + ":" + line + ")")) {
                    label.append(' ');
                    label.append(suffix);
                }
            }
        }
        if (element instanceof DSPDebugElement && (debugElement = (DSPDebugElement)((Object)element)).getErrorMessage() != null) {
            label.append(" <error:");
            label.append(debugElement.getErrorMessage());
            label.append('>');
        }
        return label.toString();
    }

    private int getLine(DSPStackFrame frame) {
        try {
            return frame.getLineNumber();
        }
        catch (DebugException ex) {
            DSPPlugin.logWarning("Failed to determine stack frame line number", ex);
            return 0;
        }
    }

    public @Nullable Font getFont(Object element) {
        DSPDebugElement debugElement;
        if (element instanceof DSPDebugElement && (debugElement = (DSPDebugElement)((Object)element)).getErrorMessage() != null) {
            return this.italic();
        }
        return null;
    }

    private Font italic() {
        FontData[] fontData;
        if (this.italic != null) {
            return this.italic;
        }
        Font dialogFont = JFaceResources.getDialogFont();
        FontData[] fontDataArray = fontData = dialogFont.getFontData();
        int n = fontData.length;
        int n2 = 0;
        while (n2 < n) {
            FontData data = fontDataArray[n2];
            data.setStyle(2);
            ++n2;
        }
        Display display = DSPDebugModelPresentation.getDisplay();
        this.italic = new Font((Device)display, fontData);
        return this.italic;
    }

    public void dispose() {
        if (this.italic != null) {
            this.italic.dispose();
        }
        super.dispose();
    }

    public @Nullable IEditorInput getEditorInput(Object element) {
        if (element instanceof ILineBreakpoint) {
            ILineBreakpoint lineBreakpoint = (ILineBreakpoint)element;
            return new FileEditorInput((IFile)lineBreakpoint.getMarker().getResource());
        }
        if (element instanceof IFile) {
            IFile file = (IFile)element;
            return new FileEditorInput(file);
        }
        IFileStore fileStore = EFS.getLocalFileSystem().getStore((IPath)new Path(element.toString()));
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IFile[] files = root.findFilesForLocationURI(fileStore.toURI());
        if (files != null) {
            IFile[] iFileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                IFile file = iFileArray[n2];
                if (file.exists()) {
                    return new FileEditorInput(file);
                }
                ++n2;
            }
        }
        return new FileStoreEditorInput(fileStore);
    }

    public @Nullable String getEditorId(IEditorInput input, Object element) {
        String id = null;
        if (input != null) {
            String lid;
            ISourcePresentation sourcePres;
            IEditorDescriptor descriptor = null;
            if (input instanceof IFileEditorInput) {
                IFileEditorInput fileEditorInput = (IFileEditorInput)input;
                IFile file = fileEditorInput.getFile();
                descriptor = IDE.getDefaultEditor((IFile)file);
            } else if (input instanceof IURIEditorInput) {
                IURIEditorInput uriEditorInput = (IURIEditorInput)input;
                URI uri = uriEditorInput.getURI();
                try {
                    IFileStore fileStore = EFS.getStore((URI)uri);
                    id = IDE.getEditorDescriptorForFileStore((IFileStore)fileStore, (boolean)false).getId();
                }
                catch (CoreException fileStore) {
                    // empty catch block
                }
            }
            if (id == null) {
                if (descriptor == null) {
                    IEditorRegistry registry = PlatformUI.getWorkbench().getEditorRegistry();
                    descriptor = registry.getDefaultEditor(input.getName());
                }
                id = "org.eclipse.ui.genericeditor.GenericEditor";
                if (descriptor != null) {
                    id = descriptor.getId();
                }
            }
            if (id == null && element instanceof ILineBreakpoint && (sourcePres = (ISourcePresentation)Platform.getAdapterManager().getAdapter(element, ISourcePresentation.class)) != null && (lid = sourcePres.getEditorId(input, element)) != null) {
                id = lid;
            }
        }
        return id;
    }

    public void setAttribute(String attribute, @Nullable Object value) {
    }

    public void computeDetail(IValue value, IValueDetailListener listener) {
        try {
            listener.detailComputed(value, value.getValueString());
        }
        catch (DebugException e) {
            DSPPlugin.logError("Failed to compute detail value", e);
        }
    }

    private static boolean endsWith(StringBuilder sb, String suffix) {
        int sbLen = sb.length();
        int suffixLen = suffix.length();
        if (suffixLen > sbLen) {
            return false;
        }
        int i = 1;
        while (i <= suffixLen) {
            if (sb.charAt(sbLen - i) != suffix.charAt(suffixLen - i)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static Display getDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }
}

