/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.composer.api.entities;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.client.HttpClient;
import org.eclipse.php.composer.api.collection.JsonArray;
import org.eclipse.php.composer.api.entities.JsonCollection;
import org.eclipse.php.composer.api.entities.JsonEntity;
import org.eclipse.php.composer.api.entities.JsonValue;
import org.eclipse.php.composer.api.objects.JsonObject;

public abstract class AbstractJsonObject<V>
extends JsonEntity
implements JsonCollection {
    private transient Map<String, PropertyChangeListener> listeners = new HashMap<String, PropertyChangeListener>();
    protected transient Map<String, V> properties = new LinkedHashMap<String, V>();
    private transient Log log = LogFactory.getLog(HttpClient.class);

    @Override
    protected void doParse(Object obj) {
        this.clear();
        if (obj instanceof LinkedHashMap) {
            List<String> fields = this.getFieldNames(this.getClass());
            LinkedHashMap json = (LinkedHashMap)obj;
            for (Map.Entry entry : ((Map)obj).entrySet()) {
                String property = (String)entry.getKey();
                if (fields.contains(property)) {
                    this.parseField(json, property);
                    continue;
                }
                JsonEntity value = null;
                if (json.containsKey(property)) {
                    value = (JsonEntity)json.get(property);
                    if (value instanceof LinkedList) {
                        value = new JsonArray(value);
                    } else if (value instanceof LinkedHashMap) {
                        value = new JsonObject(value);
                    }
                }
                this.set(property, value);
            }
        }
    }

    protected void parseField(LinkedHashMap json, String property) {
        Field field;
        if (json.containsKey(property) && (field = this.getFieldByName(this.getClass(), property)) != null && JsonEntity.class.isAssignableFrom(field.getType())) {
            try {
                field.setAccessible(true);
                JsonEntity entity = (JsonEntity)field.get(this);
                entity.fromJson(json.get(property));
            }
            catch (Exception e) {
                this.log.error((Object)e);
            }
        }
    }

    @Override
    protected Object buildJson() {
        LinkedList<String> propsOrder = new LinkedList<String>(this.sortOrder);
        HashMap<String, Field> namedFields = new HashMap<String, Field>();
        for (Field field : this.getFields(this.getClass())) {
            field.setAccessible(true);
            String fieldName = this.getFieldName(field);
            namedFields.put(fieldName, field);
            propsOrder.add(fieldName);
        }
        for (Map.Entry entry : this.properties.entrySet()) {
            propsOrder.add((String)entry.getKey());
        }
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
        for (String entry : propsOrder) {
            if (linkedHashMap.containsKey(entry)) continue;
            Object value = null;
            if (namedFields.containsKey(entry)) {
                try {
                    value = ((Field)namedFields.get(entry)).get(this);
                }
                catch (Exception e) {
                    this.log.error((Object)e);
                }
            } else if (this.properties.containsKey(entry)) {
                value = this.properties.get(entry);
            }
            if ((value = this.getJsonValue(value)) == null || value.equals("")) continue;
            linkedHashMap.put(entry, value);
        }
        return linkedHashMap;
    }

    protected List<String> getOwnProperties() {
        return new ArrayList<String>();
    }

    @Override
    public int size() {
        return this.properties.size();
    }

    @Override
    public void clear() {
        List<String> ownProps = this.getOwnProperties();
        String[] stringArray = this.properties.keySet().toArray(new String[0]);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            if (ownProps.contains(key)) {
                V value = this.properties.get(key);
                if (value instanceof JsonCollection) {
                    JsonCollection entity = (JsonCollection)value;
                    entity.clear();
                } else {
                    this.remove(key);
                }
            } else {
                this.remove(key);
            }
            ++n2;
        }
        for (Field field : this.getFields(this.getClass())) {
            if (field == null || !JsonCollection.class.isAssignableFrom(field.getType())) continue;
            try {
                field.setAccessible(true);
                JsonCollection entity = (JsonCollection)field.get(this);
                entity.clear();
            }
            catch (Exception e) {
                this.log.error((Object)e);
            }
        }
        this.sortOrder.clear();
    }

    public boolean has(String property) {
        return this.properties.containsKey(property);
    }

    public V get(String property) {
        return this.properties.get(property);
    }

    public void set(String property, Object value) {
        this.set(property, value, true);
    }

    protected void set(String property, Object value, boolean notify) {
        this.uninstallListener(property);
        JsonEntity entity = null;
        if (value instanceof JsonValue) {
            entity = this.getEntity(value);
        } else if (value instanceof JsonEntity) {
            entity = (JsonEntity)value;
        }
        if (entity != null && !this.listeners.containsKey(property)) {
            this.installListener(property, entity);
        }
        V oldValue = this.properties.get(property);
        this.properties.put(property, value);
        this.appendSortOrder(property);
        if (notify) {
            this.firePropertyChange(property, oldValue, value);
        }
    }

    public void remove(String property) {
        this.uninstallListener(property);
        V oldValue = this.get(property);
        this.properties.remove(property);
        this.firePropertyChange(property, oldValue, null);
    }

    private void installListener(final String property, JsonEntity entity) {
        if (entity != null) {
            this.listeners.put(property, new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    AbstractJsonObject.this.firePropertyChange(property + "." + evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
                }
            });
            entity.addPropertyChangeListener(this.listeners.get(property));
        }
    }

    private void uninstallListener(String property) {
        if (this.listeners.containsKey(property)) {
            JsonEntity entity;
            if (this.has(property) && (entity = this.getEntity(this.get(property))) != null) {
                entity.removePropertyChangeListener(this.listeners.get(property));
            }
            this.listeners.remove(property);
        }
    }

    private JsonEntity getEntity(Object value) {
        JsonEntity entity = null;
        if (value instanceof JsonValue) {
            JsonValue val = (JsonValue)value;
            if (val.isArray()) {
                entity = val.getAsArray();
            }
            if (val.isObject()) {
                entity = val.getAsObject();
            }
        }
        return entity;
    }
}

