/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.gitflow.ui.internal.actions;

import java.io.IOException;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.egit.core.internal.job.JobUtil;
import org.eclipse.egit.core.op.IEGitOperation;
import org.eclipse.egit.gitflow.GitFlowRepository;
import org.eclipse.egit.gitflow.WrongGitFlowStateException;
import org.eclipse.egit.gitflow.op.HotfixFinishOperation;
import org.eclipse.egit.gitflow.ui.Activator;
import org.eclipse.egit.gitflow.ui.internal.JobFamilies;
import org.eclipse.egit.gitflow.ui.internal.UIText;
import org.eclipse.egit.gitflow.ui.internal.actions.AbstractGitFlowHandler;
import org.eclipse.egit.gitflow.ui.internal.actions.GitFlowHandlerUtil;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jgit.api.MergeResult;
import org.eclipse.osgi.util.NLS;

public class HotfixFinishHandler
extends AbstractGitFlowHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        MergeResult mergeResult;
        String develop;
        String hotfixBranch;
        block6: {
            GitFlowRepository gfRepo;
            block5: {
                gfRepo = GitFlowHandlerUtil.getRepository(event);
                if (gfRepo == null) {
                    return Activator.error(UIText.Handlers_noGitflowRepositoryFound);
                }
                HotfixFinishOperation hotfixFinishOperation = new HotfixFinishOperation(gfRepo);
                hotfixBranch = gfRepo.getRepository().getBranch();
                develop = gfRepo.getConfig().getDevelop();
                JobUtil.scheduleUserWorkspaceJob((IEGitOperation)hotfixFinishOperation, (String)UIText.HotfixFinishHandler_finishingHotfix, (Object)JobFamilies.GITFLOW_FAMILY);
                IJobManager jobMan = Job.getJobManager();
                jobMan.join(JobFamilies.GITFLOW_FAMILY, null);
                mergeResult = hotfixFinishOperation.getMergeResult();
                MergeResult.MergeStatus mergeStatus = mergeResult.getMergeStatus();
                if (MergeResult.MergeStatus.CONFLICTING.equals((Object)mergeStatus)) break block5;
                return null;
            }
            if (!this.handleConflictsOnMaster(gfRepo)) break block6;
            return null;
        }
        try {
            MultiStatus status = this.createMergeConflictInfo(develop, hotfixBranch, mergeResult);
            ErrorDialog.openError(null, (String)UIText.HotfixFinishHandler_Conflicts, null, (IStatus)status);
        }
        catch (IOException | InterruptedException | CoreException | OperationCanceledException | WrongGitFlowStateException e) {
            return Activator.error(e.getMessage(), e);
        }
        return null;
    }

    private boolean handleConflictsOnMaster(GitFlowRepository gfRepo) throws IOException {
        if (!gfRepo.isMaster()) {
            return false;
        }
        String master = gfRepo.getConfig().getMaster();
        MessageDialog.openError(null, (String)UIText.HotfixFinishHandler_Conflicts, (String)NLS.bind((String)UIText.HotfixFinishOperation_unexpectedConflictsHotfixAborted, (Object)master));
        return true;
    }
}

