/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.draw2d.ui.figures;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;

public class ConstrainedToolbarLayout
extends ToolbarLayout {
    private boolean stretchMajorAxis = true;
    private boolean reversed = false;
    private boolean ignoreInvisibleChildren = true;
    private Map constraints;

    public ConstrainedToolbarLayout() {
        this(false);
    }

    public ConstrainedToolbarLayout(boolean isHorizontal) {
        super(isHorizontal);
        this.setStretchMinorAxis(true);
        this.setStretchMajorAxis(true);
        this.setMinorAlignment(0);
    }

    protected Dimension calculatePreferredSize(IFigure container, int wHint, int hHint) {
        Insets insets = container.getInsets();
        if (!container.isVisible()) {
            return new Dimension(insets.getWidth(), insets.getHeight());
        }
        if (this.isHorizontal()) {
            wHint = -1;
            if (hHint >= 0) {
                hHint = Math.max(0, hHint - insets.getHeight());
            }
        } else {
            hHint = -1;
            if (wHint >= 0) {
                wHint = Math.max(0, wHint - insets.getWidth());
            }
        }
        List children = this.getChildren(container);
        Dimension prefSize = this.calculateChildrenSize(children, wHint, hHint, true);
        if (wHint >= 0 && prefSize.width > wHint) {
            prefSize = this.calculateChildrenSize(children, prefSize.width, hHint, true);
        } else if (hHint >= 0 && prefSize.width > hHint) {
            prefSize = this.calculateChildrenSize(children, wHint, prefSize.width, true);
        }
        prefSize.height += Math.max(0, children.size() - 1) * this.getSpacing();
        return this.transposer.t(prefSize).expand(insets.getWidth(), insets.getHeight()).union(this.getBorderPreferredSize(container));
    }

    public Dimension calculateMinimumSize(IFigure container, int wHint, int hHint) {
        Insets insets = container.getInsets();
        if (!container.isVisible()) {
            return new Dimension(insets.getWidth(), insets.getHeight());
        }
        if (this.isHorizontal()) {
            wHint = -1;
            if (hHint >= 0) {
                hHint = Math.max(0, hHint - insets.getHeight());
            }
        } else {
            hHint = -1;
            if (wHint >= 0) {
                wHint = Math.max(0, wHint - insets.getWidth());
            }
        }
        List children = this.getChildren(container);
        Dimension minSize = this.calculateChildrenSize(children, wHint, hHint, false);
        if (wHint >= 0 && minSize.width > wHint) {
            minSize = this.calculateChildrenSize(children, minSize.width, hHint, false);
        } else if (hHint >= 0 && minSize.width > hHint) {
            minSize = this.calculateChildrenSize(children, wHint, minSize.width, false);
        }
        minSize.height += Math.max(0, children.size() - 1) * this.getSpacing();
        return this.transposer.t(minSize).expand(insets.getWidth(), insets.getHeight()).union(this.getBorderPreferredSize(container));
    }

    public void layout(IFigure parent) {
        int prefHeight;
        IFigure child;
        if (!parent.isVisible()) {
            return;
        }
        List children = this.getChildren(parent);
        int numChildren = children.size();
        Rectangle clientArea = this.transposer.t(parent.getClientArea());
        int x = clientArea.x;
        int y = clientArea.y;
        int availableHeight = clientArea.height;
        Dimension[] prefSizes = new Dimension[numChildren];
        Dimension[] minSizes = new Dimension[numChildren];
        Dimension[] maxSizes = new Dimension[numChildren];
        int wHint = -1;
        int hHint = -1;
        if (this.isHorizontal()) {
            hHint = parent.getClientArea((Rectangle)Rectangle.SINGLETON).height;
        } else {
            wHint = parent.getClientArea((Rectangle)Rectangle.SINGLETON).width;
        }
        int totalHeight = 0;
        int totalMinHeight = 0;
        double totalMaxHeight = 0.0;
        int prefMinSumHeight = 0;
        double prefMaxSumHeight = 0.0;
        int i = 0;
        while (i < numChildren) {
            child = (IFigure)children.get(i);
            prefSizes[i] = this.transposer.t(child.getPreferredSize(wHint, hHint));
            minSizes[i] = this.transposer.t(child.getMinimumSize(wHint, hHint));
            maxSizes[i] = this.transposer.t(child.getMaximumSize());
            if (this.getConstraint(child) != null) {
                double ratio = (Double)this.getConstraint(child);
                prefHeight = (int)(ratio * (double)availableHeight);
                prefHeight = Math.max(prefHeight, minSizes[i].height);
                prefSizes[i].height = prefHeight = Math.min(prefHeight, maxSizes[i].height);
            }
            totalHeight += prefSizes[i].height;
            totalMinHeight += minSizes[i].height;
            totalMaxHeight += (double)maxSizes[i].height;
            ++i;
        }
        prefMinSumHeight = (totalHeight += (numChildren - 1) * this.getSpacing()) - (totalMinHeight += (numChildren - 1) * this.getSpacing());
        prefMaxSumHeight = (totalMaxHeight += (double)((numChildren - 1) * this.getSpacing())) - (double)totalHeight;
        int amntShrinkHeight = totalHeight - Math.max(availableHeight, totalMinHeight);
        int i2 = 0;
        while (i2 < numChildren) {
            int amntShrinkCurrentHeight = 0;
            prefHeight = prefSizes[i2].height;
            int minHeight = minSizes[i2].height;
            int maxHeight = maxSizes[i2].height;
            int prefWidth = prefSizes[i2].width;
            int minWidth = minSizes[i2].width;
            int maxWidth = maxSizes[i2].width;
            Rectangle newBounds = new Rectangle(x, y, prefWidth, prefHeight);
            child = (IFigure)children.get(i2);
            if (this.getStretchMajorAxis()) {
                if (amntShrinkHeight > 0 && prefMinSumHeight != 0) {
                    amntShrinkCurrentHeight = (int)((long)(prefHeight - minHeight) * (long)amntShrinkHeight / (long)prefMinSumHeight);
                } else if (amntShrinkHeight < 0 && totalHeight != 0) {
                    amntShrinkCurrentHeight = (int)((double)(maxHeight - prefHeight) / prefMaxSumHeight * (double)amntShrinkHeight);
                }
            }
            int width = Math.min(prefWidth, maxWidth);
            if (this.isStretchMinorAxis()) {
                width = maxWidth;
            }
            newBounds.width = width = Math.max(minWidth, Math.min(clientArea.width, width));
            int adjust = clientArea.width - width;
            switch (this.getMinorAlignment()) {
                case 1: {
                    adjust = 0;
                    break;
                }
                case 0: {
                    adjust /= 2;
                    break;
                }
            }
            newBounds.x += adjust;
            if (newBounds.height - amntShrinkCurrentHeight > maxHeight) {
                amntShrinkCurrentHeight = newBounds.height - maxHeight;
            }
            newBounds.height -= amntShrinkCurrentHeight;
            child.setBounds(this.transposer.t(newBounds));
            amntShrinkHeight -= amntShrinkCurrentHeight;
            prefMinSumHeight -= prefHeight - minHeight;
            prefMaxSumHeight -= (double)(maxHeight - prefHeight);
            totalHeight -= prefHeight;
            y += newBounds.height + this.getSpacing();
            ++i2;
        }
    }

    public Object getConstraint(IFigure child) {
        if (this.constraints != null) {
            return this.constraints.get(child);
        }
        return null;
    }

    public void setConstraint(IFigure child, Object constraint) {
        if (!(constraint instanceof Double)) {
            return;
        }
        if (constraint instanceof Double) {
            Double c = (Double)constraint;
            super.setConstraint(child, constraint);
            if (this.constraints == null) {
                this.constraints = new HashMap();
            }
            if (constraint == null || c <= 0.0) {
                if (this.constraints.containsKey(child)) {
                    this.constraints.remove(child);
                }
            } else {
                this.constraints.put(child, constraint);
            }
        }
    }

    public void remove(IFigure child) {
        super.remove(child);
        this.setConstraint(child, null);
    }

    public void setStretchMajorAxis(boolean stretch) {
        this.stretchMajorAxis = stretch;
    }

    public boolean getStretchMajorAxis() {
        return this.stretchMajorAxis;
    }

    public void setReversed(boolean reversed) {
        this.reversed = reversed;
    }

    public boolean isReversed() {
        return this.reversed;
    }

    public void setIgnoreInvisibleChildren(boolean ignoreInvisibleChildren) {
        this.ignoreInvisibleChildren = ignoreInvisibleChildren;
    }

    public boolean getIgnoreInvisibleChildren() {
        return this.ignoreInvisibleChildren;
    }

    private Dimension calculateChildrenSize(List children, int wHint, int hHint, boolean preferred) {
        int height = 0;
        int width = 0;
        int i = 0;
        while (i < children.size()) {
            IFigure child = (IFigure)children.get(i);
            Dimension childSize = this.transposer.t(preferred ? child.getPreferredSize(wHint, hHint) : child.getMinimumSize(wHint, hHint));
            height += childSize.height;
            width = Math.max(width, childSize.width);
            ++i;
        }
        return new Dimension(width, height);
    }

    private List getChildren(IFigure container) {
        ArrayList children = new ArrayList(container.getChildren());
        if (this.getIgnoreInvisibleChildren()) {
            Iterator iter = children.iterator();
            while (iter.hasNext()) {
                IFigure f = (IFigure)iter.next();
                if (f.isVisible()) continue;
                iter.remove();
            }
        }
        if (this.isReversed()) {
            Collections.reverse(children);
        }
        return children;
    }
}

