/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.routers;

import org.eclipse.draw2d.AbstractRouter;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gmf.runtime.draw2d.ui.geometry.LineSeg;
import org.eclipse.gmf.runtime.draw2d.ui.internal.routers.OrthogonalRouterUtilities;
import org.eclipse.sirius.diagram.ui.tools.internal.routers.DTreeRouter;

public class DBranchRouter
extends AbstractRouter {
    private final DTreeRouter tree;

    public DBranchRouter(DTreeRouter tree) {
        this.tree = tree;
    }

    public void route(Connection conn) {
        this.internalRoute(conn);
    }

    private void internalRoute(Connection conn) {
        Point ptTrunkLoc = this.getTrunkLocation(conn);
        this.getTree().setTrunkLocation(conn, ptTrunkLoc);
        Point ptSourceLoc = this.getSourceLocation(conn, ptTrunkLoc);
        PointList points = this.recreateBranch(conn, ptSourceLoc, ptTrunkLoc);
        conn.setPoints(points);
    }

    protected Point getTrunkLocation(Connection conn) {
        PointList points = this.getTree().getPointsFromConstraint(conn);
        Point ptTrunkLoc = this.getTree().getTrunkLocation(conn);
        if (this.getTree().isTreeBranch(conn, points)) {
            if (this.getTree().isTopDown(conn)) {
                ptTrunkLoc.setX(points.getPoint((int)3).x);
            } else {
                ptTrunkLoc.setY(points.getPoint((int)3).y);
            }
            if (this.getTree().isOrthogonalTreeBranch(conn, points)) {
                if (this.getTree().isTopDown(conn)) {
                    ptTrunkLoc.setY(points.getPoint((int)2).y);
                } else {
                    ptTrunkLoc.setX(points.getPoint((int)2).x);
                }
            }
        }
        return ptTrunkLoc;
    }

    public Point getSourceLocation(Connection conn, Point ptTrunkLoc) {
        Point ptSourceRef = conn.getSourceAnchor().getReferencePoint();
        Point absoluteTrunkLocation = ptTrunkLoc.getCopy();
        conn.translateToAbsolute((Translatable)absoluteTrunkLocation);
        boolean bTopDown = this.getTree().isTopDown(conn);
        int branchOffset = bTopDown ? ptSourceRef.x : ptSourceRef.y;
        Point ref = bTopDown ? new Point(branchOffset, absoluteTrunkLocation.y) : new Point(absoluteTrunkLocation.x, branchOffset);
        conn.translateToRelative((Translatable)ref);
        LineSeg line = OrthogonalRouterUtilities.getOrthogonalLineSegToAnchorLoc((Connection)conn, (ConnectionAnchor)conn.getSourceAnchor(), (Point)ref);
        return line.getOrigin();
    }

    public PointList recreateBranch(Connection conn, Point ptSourceLoc, Point ptTrunkLoc) {
        PointList points = new PointList(4);
        boolean bTopDown = this.getTree().isTopDown(conn);
        points.addPoint(new Point(ptSourceLoc));
        Point pt2 = bTopDown ? new Point(ptSourceLoc.x, ptTrunkLoc.y) : new Point(ptTrunkLoc.x, ptSourceLoc.y);
        points.addPoint(pt2);
        points.addPoint(new Point(ptTrunkLoc));
        LineSeg line = OrthogonalRouterUtilities.getOrthogonalLineSegToAnchorLoc((Connection)conn, (ConnectionAnchor)conn.getTargetAnchor(), (Point)ptTrunkLoc);
        Point ptTargetLoc = line.getOrigin();
        Point pt4 = bTopDown ? new Point(ptTrunkLoc.x, ptTargetLoc.y) : new Point(ptTargetLoc.x, ptTrunkLoc.y);
        points.addPoint(pt4);
        return points;
    }

    protected DTreeRouter getTree() {
        return this.tree;
    }
}

