/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.part;

import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.palette.PanningSelectionToolEntry;
import org.eclipse.gmf.runtime.common.ui.services.marker.MarkerNavigationService;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.IDiagramDocument;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.IDocument;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.parts.DiagramDocumentEditor;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.diagram.ui.business.api.view.SiriusGMFHelper;
import org.eclipse.sirius.diagram.ui.provider.DiagramUIPlugin;
import org.eclipse.sirius.diagram.ui.tools.internal.palette.SiriusSelectionToolEx;
import org.eclipse.sirius.ui.business.api.session.SessionEditorInput;
import org.eclipse.sirius.viewpoint.provider.SiriusEditPlugin;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.part.IShowInTargetList;
import org.eclipse.ui.part.ShowInContext;
import org.eclipse.ui.views.properties.IPropertySheetPage;

public class SiriusDiagramEditor
extends DiagramDocumentEditor
implements IGotoMarker,
IAdaptable {
    public static final String CONTEXT_ID = "org.eclipse.sirius.diagram.ui.diagramContext";
    private PaletteRoot previousPalette = null;

    public SiriusDiagramEditor() {
        super(true);
    }

    protected String getContextID() {
        return CONTEXT_ID;
    }

    protected PaletteRoot createPaletteRoot(PaletteRoot existingPaletteRoot) {
        if (this.previousPalette == null) {
            this.previousPalette = super.createPaletteRoot(existingPaletteRoot);
            if (this.previousPalette.getDefaultEntry() instanceof PanningSelectionToolEntry) {
                this.previousPalette.getDefaultEntry().setToolClass(SiriusSelectionToolEx.class);
            }
        }
        return this.previousPalette;
    }

    protected PreferencesHint getPreferencesHint() {
        return DiagramUIPlugin.DIAGRAM_PREFERENCES_HINT;
    }

    public String getContributorId() {
        return "org.eclipse.sirius.diagram.ui";
    }

    public Object getAdapter(Class type) {
        IPropertySheetPage contributedPage;
        if (type == IShowInTargetList.class) {
            return new IShowInTargetList(){

                public String[] getShowInTargetIds() {
                    return new String[]{"org.eclipse.ui.navigator.ProjectExplorer", "org.eclipse.sirius.ui.tools.views.model.explorer"};
                }
            };
        }
        if (type == IPropertySheetPage.class && (contributedPage = SiriusEditPlugin.getPlugin().getPropertySheetPage((Object)this, this.getContributorId())) != null) {
            return contributedPage;
        }
        if (type == AdapterFactory.class) {
            return DiagramUIPlugin.getPlugin().getItemProvidersAdapterFactory();
        }
        return super.getAdapter(type);
    }

    public TransactionalEditingDomain getEditingDomain() {
        IDocument document;
        IDocument iDocument = document = this.getEditorInput() != null ? this.getDocumentProvider().getDocument((Object)this.getEditorInput()) : null;
        if (document instanceof IDiagramDocument) {
            return ((IDiagramDocument)document).getEditingDomain();
        }
        return super.getEditingDomain();
    }

    public void gotoMarker(IMarker marker) {
        MarkerNavigationService.getInstance().gotoMarker((IEditorPart)this, marker);
    }

    public PreferenceStore getWorkspaceViewerPreferenceStore() {
        if (this.workspaceViewerPreferenceStore != null) {
            return this.workspaceViewerPreferenceStore;
        }
        IPath path = DiagramUIPlugin.getPlugin().getStateLocation();
        String viewId = SiriusGMFHelper.getViewId((View)this.getDiagram());
        String fileName = path.toString() + "/" + viewId;
        File file = new File(fileName);
        this.workspaceViewerPreferenceStore = new PreferenceStore(fileName);
        if (file.exists()) {
            try {
                this.workspaceViewerPreferenceStore.load();
            }
            catch (Exception exception) {
                this.addDefaultPreferences();
            }
        } else {
            this.addDefaultPreferences();
        }
        return this.workspaceViewerPreferenceStore;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void doSaveAs() {
    }

    protected void performSaveAs(IProgressMonitor progressMonitor) {
    }

    public ShowInContext getShowInContext() {
        return new ShowInContext((Object)this.getEditorInput(), this.getNavigatorSelection());
    }

    private ISelection getNavigatorSelection() {
        IFile file;
        Resource sessionResource;
        SessionEditorInput sessionEditorInput;
        Session session;
        if (this.getEditorInput() instanceof SessionEditorInput && (session = (sessionEditorInput = (SessionEditorInput)this.getEditorInput()).getSession(false)) != null && (sessionResource = session.getSessionResource()) != null && sessionResource.getURI().isPlatformResource() && (file = WorkspaceSynchronizer.getFile((Resource)sessionResource)) != null) {
            return new StructuredSelection((Object)file);
        }
        return StructuredSelection.EMPTY;
    }
}

