/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.net4j.protocol;

import java.io.IOException;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.CDOServerProtocol;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.CDOServerReadIndication;
import org.eclipse.emf.cdo.spi.common.branch.InternalCDOBranch;
import org.eclipse.emf.cdo.spi.common.branch.InternalCDOBranchManager;

public class LoadSubBranchesIndication
extends CDOServerReadIndication {
    private int branchID;

    public LoadSubBranchesIndication(CDOServerProtocol protocol) {
        super(protocol, (short)35);
    }

    @Override
    protected void indicating(CDODataInput in) throws IOException {
        this.branchID = in.readXInt();
    }

    @Override
    protected void responding(CDODataOutput out) throws IOException {
        InternalCDOBranchManager branchManager = this.getRepository().getBranchManager();
        InternalCDOBranch branch = branchManager.getBranch(this.branchID);
        InternalCDOBranch[] branches = branch.getBranches();
        out.writeXInt(branches.length);
        InternalCDOBranch[] internalCDOBranchArray = branches;
        int n = branches.length;
        int n2 = 0;
        while (n2 < n) {
            InternalCDOBranch subBranch = internalCDOBranchArray[n2];
            InternalCDOBranchManager.BranchLoader.SubBranchInfo info = new InternalCDOBranchManager.BranchLoader.SubBranchInfo(subBranch.getID(), subBranch.getName(), subBranch.getBase().getTimeStamp());
            info.write(out);
            ++n2;
        }
    }
}

