/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.correction;

import java.util.Arrays;
import java.util.Set;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.build.IBuildEntry;
import org.eclipse.pde.internal.core.text.build.Build;
import org.eclipse.pde.internal.core.text.build.BuildEntry;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.correction.BuildEntryMarkerResolution;

public class RemoveBuildEntryResolution
extends BuildEntryMarkerResolution {
    private static final Set<String> RELEVANT_COMPILER_FLAGS = Set.of("compilers.p.build.source.library", "compilers.p.build.src.includes", "compilers.p.build.bin.includes", "compilers.p.build.output.library");

    public RemoveBuildEntryResolution(int type, IMarker marker) {
        super(type, marker);
    }

    public String getLabel() {
        if (this.fToken == null) {
            return NLS.bind((String)PDEUIMessages.RemoveBuildEntryResolution_removeEntry, (Object)this.fEntry);
        }
        return NLS.bind((String)PDEUIMessages.RemoveBuildEntryResolution_removeToken, (Object)this.fToken, (Object)this.fEntry);
    }

    @Override
    protected void createChange(Build build) {
        try {
            this.fEntry = (String)this.marker.getAttribute("buildEntry.key");
            this.fToken = (String)this.marker.getAttribute("buildEntry.tokenValue");
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        try {
            BuildEntry buildEntry = (BuildEntry)build.getEntry(this.fEntry);
            if (buildEntry == null) {
                return;
            }
            if (this.fToken == null) {
                build.remove((IBuildEntry)buildEntry);
            } else {
                buildEntry.removeToken(this.fToken);
                if (buildEntry.getTokens().length == 0) {
                    build.remove((IBuildEntry)buildEntry);
                }
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    @Override
    public void run(IMarker marker) {
        super.run(marker);
        this.marker = marker;
    }

    @Override
    public IMarker[] findOtherMarkers(IMarker[] markers) {
        return (IMarker[])Arrays.stream(markers).filter(m -> !m.equals((Object)this.marker)).filter(m -> RELEVANT_COMPILER_FLAGS.contains(m.getAttribute("compilerKey", ""))).toArray(IMarker[]::new);
    }
}

