/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.plan.treeplan;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.datatools.sqltools.plan.IExecutionPlanDocument;
import org.eclipse.datatools.sqltools.plan.treeplan.TreePlanNodeComponent;

public class TreeExecutionPlanDocument
implements IExecutionPlanDocument {
    private Object _data;
    private String _name;
    private ArrayList _nodeCount;
    private TreePlanNodeComponent _rootNode;

    public TreeExecutionPlanDocument(TreePlanNodeComponent rootNode, String name, Object data) {
        this._rootNode = rootNode;
        this._name = name == null ? "" : name;
        this._data = data;
        this._nodeCount = new ArrayList();
    }

    public Object getData() {
        return this._data;
    }

    private void getMaxNodeCount(TreePlanNodeComponent root, int depth) {
        int max = root.getChildrenCount();
        if (this._nodeCount.size() <= depth) {
            this._nodeCount.add(max);
        } else {
            this._nodeCount.set(depth, (Integer)this._nodeCount.get(depth) + max);
        }
        ArrayList children = root.getChildren();
        Iterator iter = null;
        if (children != null) {
            iter = children.iterator();
        }
        while (iter != null && iter.hasNext()) {
            this.getMaxNodeCount((TreePlanNodeComponent)iter.next(), depth + 1);
        }
    }

    public int getMaxWidth() {
        this._nodeCount = new ArrayList();
        this._nodeCount.add(1);
        this.getMaxNodeCount(this._rootNode, 1);
        int max = 1;
        Iterator iter = this._nodeCount.iterator();
        while (iter.hasNext()) {
            int level = (Integer)iter.next();
            if (level <= max) continue;
            max = level;
        }
        return max;
    }

    @Override
    public String getName() {
        return this._name;
    }

    public TreePlanNodeComponent getRootNode() {
        return this._rootNode;
    }

    public int getWidth(int depth) {
        return (Integer)this._nodeCount.get(depth);
    }

    public void setData(Object data) {
        this._data = data;
    }

    public void setName(String name) {
        this._name = name;
    }

    public void setRootNode(TreePlanNodeComponent rootNode) {
        this._rootNode = rootNode;
    }
}

