/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.wtp.internal.conversion;

import org.apache.maven.model.Build;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.m2e.wtp.WTPProjectsUtil;
import org.eclipse.m2e.wtp.internal.conversion.AbstractWtpProjectConversionParticipant;
import org.eclipse.m2e.wtp.internal.conversion.MavenPluginUtils;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.componentcore.resources.IVirtualResource;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;

public class ConnectorProjectConverter
extends AbstractWtpProjectConversionParticipant {
    private static final String DEFAULT_RA_XML = "src/main/rar/META-INF/ra.xml";

    public void convert(IProject project, Model model, IProgressMonitor monitor) throws CoreException {
        if (!this.accept(project) || !"rar".equals(model.getPackaging())) {
            return;
        }
        IVirtualComponent component = ComponentCore.createComponent((IProject)project);
        if (component == null) {
            return;
        }
        this.setJarPlugin(component, model);
        this.setRarPlugin(component, model);
    }

    private void setJarPlugin(IVirtualComponent component, Model model) {
        Build build = this.getCloneOrCreateBuild(model);
        Plugin jarPlugin = this.setPlugin(build, "org.apache.maven.plugins", "maven-jar-plugin", "2.3.2");
        PluginExecution jarExecution = new PluginExecution();
        jarExecution.setId("build_jar");
        jarExecution.addGoal("jar");
        jarExecution.setPhase("prepare-package");
        jarPlugin.addExecution(jarExecution);
        model.setBuild(build);
    }

    private void setRarPlugin(IVirtualComponent component, Model model) throws CoreException {
        String raXmlPath;
        Build build = this.getCloneOrCreateBuild(model);
        String pluginVersion = this.getRarPluginVersion();
        Plugin rarPlugin = this.setPlugin(build, "org.apache.maven.plugins", "maven-rar-plugin", pluginVersion);
        IFile raXml = this.findRaXml(component);
        if (raXml != null && !DEFAULT_RA_XML.equals(raXmlPath = raXml.getProjectRelativePath().toPortableString())) {
            MavenPluginUtils.configure(rarPlugin, "raXmlFile", raXmlPath);
            model.setBuild(build);
        }
    }

    @Override
    protected IProjectFacet getRequiredFaced() {
        return WTPProjectsUtil.JCA_FACET;
    }

    private IFile findRaXml(IVirtualComponent component) throws CoreException {
        IVirtualResource[] iVirtualResourceArray = component.getRootFolder().members();
        int n = iVirtualResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IFile ra;
            IFolder f;
            IVirtualResource vr = iVirtualResourceArray[n2];
            if (vr instanceof IVirtualFolder && "META-INF".equals((f = (IFolder)((IVirtualFolder)vr).getUnderlyingFolder()).getName()) && (ra = f.getFile("ra.xml")).isAccessible()) {
                return ra;
            }
            ++n2;
        }
        return null;
    }

    private String getRarPluginVersion() {
        String version = System.getProperty("org.eclipse.m2e.wtp.conversion.rarplugin.version");
        if (version != null) {
            return version;
        }
        return MavenPluginUtils.getMostRecentPluginVersion("org.apache.maven.plugins", "maven-rar-plugin", "2.4");
    }
}

