/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.synchronize.model;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.egit.core.synchronize.GitCommitsModelCache;
import org.eclipse.egit.ui.internal.synchronize.model.GitModelBlob;
import org.eclipse.egit.ui.internal.synchronize.model.GitModelObject;
import org.eclipse.egit.ui.internal.synchronize.model.GitModelObjectContainer;
import org.eclipse.egit.ui.internal.synchronize.model.GitModelRepository;
import org.eclipse.egit.ui.internal.synchronize.model.GitModelTree;
import org.eclipse.egit.ui.internal.synchronize.model.HasProjects;
import org.eclipse.egit.ui.internal.synchronize.model.TreeBuilder;
import org.eclipse.jgit.lib.Repository;

public class GitModelCommit
extends GitModelObjectContainer
implements HasProjects {
    private final GitCommitsModelCache.Commit commit;
    private final Repository repo;
    private final IProject[] projects;
    private GitModelObject[] children;

    public GitModelCommit(GitModelRepository parent, Repository repo, GitCommitsModelCache.Commit commit, IProject[] projects) {
        super(parent);
        this.repo = repo;
        this.commit = commit;
        this.projects = projects;
    }

    @Override
    public IPath getLocation() {
        return new Path(this.repo.getWorkTree().getAbsolutePath());
    }

    @Override
    public IProject[] getProjects() {
        return this.projects;
    }

    @Override
    public int getKind() {
        return this.commit.getDirection() | 3;
    }

    @Override
    public int repositoryHashCode() {
        return this.repo.getWorkTree().hashCode();
    }

    @Override
    public String getName() {
        return this.commit.getShortMessage();
    }

    @Override
    public GitModelObject[] getChildren() {
        if (this.children == null) {
            this.children = this.createChildren();
        }
        return this.children;
    }

    private GitModelObject[] createChildren() {
        TreeBuilder.FileModelFactory fileModelFactory = new TreeBuilder.FileModelFactory(){

            @Override
            public GitModelBlob createFileModel(GitModelObjectContainer parent, Repository repository, GitCommitsModelCache.Change change, IPath fullPath) {
                return new GitModelBlob(parent, repository, change, fullPath);
            }

            @Override
            public boolean isWorkingTree() {
                return false;
            }
        };
        return TreeBuilder.build(this, this.repo, this.commit.getChildren(), fileModelFactory, GitModelTree::new);
    }

    public GitCommitsModelCache.Commit getCachedCommitObj() {
        return this.commit;
    }

    @Override
    public void dispose() {
        if (this.children != null) {
            GitModelObject[] gitModelObjectArray = this.children;
            int n = this.children.length;
            int n2 = 0;
            while (n2 < n) {
                GitModelObject child = gitModelObjectArray[n2];
                child.dispose();
                ++n2;
            }
            this.children = null;
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        GitModelCommit objCommit = (GitModelCommit)obj;
        return objCommit.commit.getId().equals((Object)this.commit.getId());
    }

    public int hashCode() {
        return this.commit.hashCode();
    }

    public String toString() {
        return "ModelCommit[" + String.valueOf(this.commit.getId()) + "]";
    }
}

