/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.instantiation.impl;

import java.text.MessageFormat;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jem.internal.instantiation.PTAnonymousClassDeclaration;
import org.eclipse.jem.internal.instantiation.PTArrayAccess;
import org.eclipse.jem.internal.instantiation.PTArrayCreation;
import org.eclipse.jem.internal.instantiation.PTArrayInitializer;
import org.eclipse.jem.internal.instantiation.PTBooleanLiteral;
import org.eclipse.jem.internal.instantiation.PTCastExpression;
import org.eclipse.jem.internal.instantiation.PTCharacterLiteral;
import org.eclipse.jem.internal.instantiation.PTClassInstanceCreation;
import org.eclipse.jem.internal.instantiation.PTConditionalExpression;
import org.eclipse.jem.internal.instantiation.PTExpression;
import org.eclipse.jem.internal.instantiation.PTFieldAccess;
import org.eclipse.jem.internal.instantiation.PTInfixExpression;
import org.eclipse.jem.internal.instantiation.PTInstanceof;
import org.eclipse.jem.internal.instantiation.PTInvalidExpression;
import org.eclipse.jem.internal.instantiation.PTMethodInvocation;
import org.eclipse.jem.internal.instantiation.PTName;
import org.eclipse.jem.internal.instantiation.PTNullLiteral;
import org.eclipse.jem.internal.instantiation.PTNumberLiteral;
import org.eclipse.jem.internal.instantiation.PTParenthesizedExpression;
import org.eclipse.jem.internal.instantiation.PTPrefixExpression;
import org.eclipse.jem.internal.instantiation.PTStringLiteral;
import org.eclipse.jem.internal.instantiation.PTThisLiteral;
import org.eclipse.jem.internal.instantiation.PTTypeLiteral;
import org.eclipse.jem.internal.instantiation.ParseVisitor;
import org.eclipse.jem.internal.instantiation.impl.InstantiationImplMessages;

public class NaiveExpressionFlattener
extends ParseVisitor {
    private StringBuffer buffer = new StringBuffer(100);

    protected final StringBuffer getStringBuffer() {
        return this.buffer;
    }

    public String getResult() {
        return this.buffer.toString();
    }

    public void reset() {
        this.buffer.setLength(0);
    }

    @Override
    public boolean visit(PTAnonymousClassDeclaration node) {
        this.buffer.append(node.getDeclaration());
        return false;
    }

    @Override
    public boolean visit(PTArrayAccess node) {
        node.getArray().accept(this);
        if (!node.getIndexes().isEmpty()) {
            EList indexes = node.getIndexes();
            int i = 0;
            while (i < indexes.size()) {
                this.buffer.append('[');
                ((PTExpression)indexes.get(i)).accept(this);
                this.buffer.append(']');
                ++i;
            }
        }
        return false;
    }

    @Override
    public boolean visit(PTArrayCreation node) {
        String arrayType = node.getType();
        int ob = arrayType.indexOf(91);
        String type = this.handleQualifiedName(arrayType.substring(0, ob));
        this.buffer.append("new ");
        this.buffer.append(type);
        int realdims = 0;
        while (ob != -1) {
            ++realdims;
            ob = arrayType.indexOf(91, ob + 1);
        }
        EList dims = node.getDimensions();
        int i = 0;
        while (i < dims.size()) {
            this.buffer.append('[');
            ((PTExpression)dims.get(i)).accept(this);
            this.buffer.append(']');
            ++i;
        }
        i = dims.size();
        while (i < realdims) {
            this.buffer.append("[]");
            ++i;
        }
        if (node.getInitializer() != null) {
            this.buffer.append(' ');
            node.getInitializer().accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(PTArrayInitializer node) {
        this.buffer.append('{');
        EList exp = node.getExpressions();
        int i = 0;
        while (i < exp.size()) {
            if (i != 0) {
                this.buffer.append(", ");
            }
            ((PTExpression)exp.get(i)).accept(this);
            ++i;
        }
        this.buffer.append('}');
        return false;
    }

    @Override
    public boolean visit(PTBooleanLiteral node) {
        this.buffer.append(node.isBooleanValue() ? "true" : "false");
        return false;
    }

    @Override
    public boolean visit(PTCastExpression node) {
        this.buffer.append('(');
        this.buffer.append(this.handleQualifiedName(node.getType()));
        this.buffer.append(") ");
        node.getExpression().accept(this);
        return false;
    }

    @Override
    public boolean visit(PTCharacterLiteral node) {
        this.buffer.append(node.getEscapedValue());
        return false;
    }

    @Override
    public boolean visit(PTClassInstanceCreation node) {
        this.buffer.append("new ");
        this.buffer.append(this.handleQualifiedName(node.getType()));
        this.buffer.append('(');
        EList args = node.getArguments();
        int i = 0;
        while (i < args.size()) {
            if (i != 0) {
                this.buffer.append(", ");
            }
            ((PTExpression)args.get(i)).accept(this);
            ++i;
        }
        this.buffer.append(')');
        return false;
    }

    @Override
    public boolean visit(PTConditionalExpression node) {
        node.getCondition().accept(this);
        this.buffer.append(" ? ");
        node.getTrue().accept(this);
        this.buffer.append(" : ");
        node.getFalse().accept(this);
        return false;
    }

    @Override
    public boolean visit(PTFieldAccess node) {
        node.getReceiver().accept(this);
        this.buffer.append('.');
        this.buffer.append(node.getField());
        return false;
    }

    @Override
    public boolean visit(PTInfixExpression node) {
        node.getLeftOperand().accept(this);
        this.buffer.append(' ');
        String oper = node.getOperator().getOperator();
        this.buffer.append(oper);
        this.buffer.append(' ');
        node.getRightOperand().accept(this);
        EList ext = node.getExtendedOperands();
        int i = 0;
        while (i < ext.size()) {
            this.buffer.append(' ');
            this.buffer.append(oper);
            this.buffer.append(' ');
            ((PTExpression)ext.get(i)).accept(this);
            ++i;
        }
        return false;
    }

    @Override
    public boolean visit(PTInstanceof node) {
        node.getOperand().accept(this);
        this.buffer.append(" instanceof ");
        this.buffer.append(this.handleQualifiedName(node.getType()));
        return false;
    }

    @Override
    public boolean visit(PTInvalidExpression node) {
        this.buffer.append(MessageFormat.format(InstantiationImplMessages.NaiveExpressionFlattener_InvalidExpression, node.getMessage()));
        return false;
    }

    @Override
    public boolean visit(PTMethodInvocation node) {
        if (node.getReceiver() != null) {
            node.getReceiver().accept(this);
            this.buffer.append('.');
        }
        this.buffer.append(node.getName());
        this.buffer.append('(');
        EList args = node.getArguments();
        int i = 0;
        while (i < args.size()) {
            if (i != 0) {
                this.buffer.append(", ");
            }
            ((PTExpression)args.get(i)).accept(this);
            ++i;
        }
        this.buffer.append(')');
        return false;
    }

    @Override
    public boolean visit(PTName node) {
        this.buffer.append(this.handleQualifiedName(node.getName()));
        return false;
    }

    @Override
    public boolean visit(PTNullLiteral node) {
        this.buffer.append("null");
        return false;
    }

    @Override
    public boolean visit(PTNumberLiteral node) {
        this.buffer.append(node.getToken());
        return false;
    }

    @Override
    public boolean visit(PTParenthesizedExpression node) {
        this.buffer.append('(');
        node.getExpression().accept(this);
        this.buffer.append(')');
        return false;
    }

    @Override
    public boolean visit(PTPrefixExpression node) {
        this.buffer.append(node.getOperator().getOperator());
        node.getExpression().accept(this);
        return false;
    }

    @Override
    public boolean visit(PTStringLiteral node) {
        this.buffer.append(node.getEscapedValue());
        return false;
    }

    @Override
    public boolean visit(PTThisLiteral node) {
        this.buffer.append("this");
        return false;
    }

    @Override
    public boolean visit(PTTypeLiteral node) {
        this.buffer.append(this.handleQualifiedName(node.getType()));
        this.buffer.append(".class");
        return false;
    }

    protected String handleQualifiedName(String qName) {
        return qName;
    }
}

