/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.pde.connector;

import java.util.List;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.project.MavenProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.configurator.AbstractProjectConfigurator;
import org.eclipse.m2e.core.project.configurator.ProjectConfigurationRequest;
import org.eclipse.m2e.pde.connector.PDEMavenBundlePluginConfigurator;
import org.eclipse.pde.ds.internal.annotations.DSAnnotationVersion;
import org.osgi.framework.Version;
import org.osgi.service.prefs.BackingStoreException;

public class TychoDSConfigurator
extends AbstractProjectConfigurator {
    private static final ILog LOG = Platform.getLog(TychoDSConfigurator.class);
    private static final String TYCHO_GROUP_ID = "org.eclipse.tycho";
    private static final String TYCHO_DS_PLUGIN_ARTIFACT_ID = "tycho-ds-plugin";
    private static final String GOAL_DECLARATIVE_SERVICES = "declarative-services";

    public void configure(ProjectConfigurationRequest request, IProgressMonitor monitor) throws CoreException {
        MavenProject project;
        boolean isDsEnabled;
        List<MojoExecution> mojoExecutions = this.getTychoDsPluginMojoExecutions(request.mavenProjectFacade(), monitor);
        if (mojoExecutions.isEmpty()) {
            return;
        }
        MojoExecution mojoExecution = mojoExecutions.get(0);
        if (mojoExecutions.size() > 1) {
            String message = String.format("Found more than one execution for plugin %s:%s and goal %s, only consider configuration of this one", TYCHO_GROUP_ID, TYCHO_DS_PLUGIN_ARTIFACT_ID, GOAL_DECLARATIVE_SERVICES);
            this.createWarningMarker(request, mojoExecution, "executions", message);
        }
        if (isDsEnabled = ((Boolean)this.maven.getMojoParameterValue(project = request.mavenProject(), mojoExecution, "enabled", Boolean.class, monitor)).booleanValue()) {
            IEclipsePreferences prefs = new ProjectScope(request.mavenProjectFacade().getProject()).getNode("org.eclipse.pde.ds.annotations");
            prefs.putBoolean("enabled", isDsEnabled);
            String dsVersion = (String)this.maven.getMojoParameterValue(project, mojoExecution, "dsVersion", String.class, monitor);
            DSAnnotationVersion version = this.parseVersion(dsVersion);
            if (version != null) {
                prefs.put("dsVersion", version.name());
            } else {
                String message = "Unsupported DS spec version " + dsVersion + " found, using default instead";
                this.createWarningMarker(request, mojoExecution, "configuration", message);
            }
            String path = (String)this.maven.getMojoParameterValue(project, mojoExecution, "path", String.class, monitor);
            prefs.put("path", path);
            try {
                prefs.flush();
            }
            catch (BackingStoreException e) {
                LOG.error("Failed to save PDE-DS preferences", (Throwable)e);
            }
        }
    }

    private DSAnnotationVersion parseVersion(String version) {
        if (version.startsWith("V")) {
            version = version.substring(1).replace('_', '.');
        }
        try {
            Version osgiVersion = Version.parseVersion((String)version);
            if (osgiVersion.getMajor() == 1 && osgiVersion.getMinor() == 1) {
                return DSAnnotationVersion.V1_1;
            }
            if (osgiVersion.getMajor() == 1 && osgiVersion.getMinor() == 2) {
                return DSAnnotationVersion.V1_2;
            }
            if (osgiVersion.getMajor() == 1 && osgiVersion.getMinor() == 3) {
                return DSAnnotationVersion.V1_3;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return null;
    }

    private List<MojoExecution> getTychoDsPluginMojoExecutions(IMavenProjectFacade projectFacade, IProgressMonitor monitor) throws CoreException {
        return projectFacade.getMojoExecutions(TYCHO_GROUP_ID, TYCHO_DS_PLUGIN_ARTIFACT_ID, monitor, new String[]{GOAL_DECLARATIVE_SERVICES});
    }

    private void createWarningMarker(ProjectConfigurationRequest request, MojoExecution execution, String attribute, String message) {
        PDEMavenBundlePluginConfigurator.createWarningMarker(this.projectManager, this.markerManager, request, execution, attribute, message);
    }
}

