/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.wtp;

import java.util.regex.Pattern;
import org.eclipse.m2e.wtp.IPackagingConfiguration;
import org.eclipse.m2e.wtp.internal.AntPathMatcher;

public class PackagingConfiguration
implements IPackagingConfiguration {
    String[] packagingIncludes;
    String[] packagingExcludes;
    private AntPathMatcher matcher;
    private static final String REGEX_BEGIN = "%regex[";
    private static final String REGEX_END = "]";

    public PackagingConfiguration(String[] packagingIncludes, String[] packagingExcludes) {
        this.packagingIncludes = this.toPortablePathArray(packagingIncludes);
        this.packagingExcludes = this.toPortablePathArray(packagingExcludes);
        this.matcher = new AntPathMatcher();
    }

    @Override
    public boolean isPackaged(String virtualPath) {
        int n;
        int n2;
        String[] stringArray;
        if (virtualPath == null) {
            return false;
        }
        virtualPath = this.toPortablePath(virtualPath);
        if (this.packagingExcludes != null) {
            stringArray = this.packagingExcludes;
            n2 = this.packagingExcludes.length;
            n = 0;
            while (n < n2) {
                String excl = stringArray[n];
                if (this.matches(excl, virtualPath)) {
                    return false;
                }
                ++n;
            }
        }
        if (this.packagingIncludes == null || this.packagingIncludes.length == 0) {
            return true;
        }
        stringArray = this.packagingIncludes;
        n2 = this.packagingIncludes.length;
        n = 0;
        while (n < n2) {
            String incl = stringArray[n];
            if (this.matches(incl, virtualPath)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private String[] toPortablePathArray(String[] patterns) {
        if (patterns == null) {
            return null;
        }
        String[] newPatterns = new String[patterns.length];
        int i = 0;
        while (i < patterns.length) {
            newPatterns[i] = this.toPortablePath(patterns[i]);
            ++i;
        }
        return newPatterns;
    }

    private String toPortablePath(String path) {
        return path == null ? null : path.replace("\\", "/");
    }

    private boolean isRegex(String regEx) {
        return regEx.startsWith(REGEX_BEGIN) && regEx.endsWith(REGEX_END);
    }

    private boolean matches(String pattern, String input) {
        if (this.isRegex(pattern)) {
            return Pattern.matches(this.convertToJavaRegEx(pattern), input);
        }
        return this.matcher.match(pattern, input);
    }

    private String convertToJavaRegEx(String regEx) {
        return regEx.substring(REGEX_BEGIN.length(), regEx.length() - REGEX_END.length());
    }
}

