/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.eclipselink.core.internal.context.java;

import java.util.List;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.internal.ArrayTools;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.iterable.EmptyIterable;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.transformer.Transformer;
import org.eclipse.jpt.jaxb.core.context.JaxbClassMapping;
import org.eclipse.jpt.jaxb.core.context.JaxbPersistentAttribute;
import org.eclipse.jpt.jaxb.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.jaxb.core.internal.context.java.AbstractJavaAttributeMapping;
import org.eclipse.jpt.jaxb.eclipselink.core.context.ELXmlInverseReferenceMapping;
import org.eclipse.jpt.jaxb.eclipselink.core.resource.java.XmlInverseReferenceAnnotation;
import org.eclipse.jpt.jaxb.eclipselink.core.validation.JptJaxbEclipseLinkCoreValidationMessages;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

public class ELJavaXmlInverseReferenceMapping
extends AbstractJavaAttributeMapping<XmlInverseReferenceAnnotation>
implements ELXmlInverseReferenceMapping {
    protected String mappedBy = this.getResourceMappedBy();
    protected static final String[] VALID_REFERENCED_ATTRIBUTE_MAPPING_KEYS = new String[]{"xml-element", "xml-element-ref", "xml-element-refs", "xml-elements", "xml-attribute", "xml-value"};

    public ELJavaXmlInverseReferenceMapping(JavaPersistentAttribute parent) {
        super(parent);
    }

    public String getKey() {
        return "xml-inverse-reference";
    }

    protected String getAnnotationName() {
        return "org.eclipse.persistence.oxm.annotations.XmlInverseReference";
    }

    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.setMappedBy_(this.getResourceMappedBy());
    }

    @Override
    public String getMappedBy() {
        return this.mappedBy;
    }

    @Override
    public void setMappedBy(String mappedBy) {
        this.getXmlInverseReferenceAnnotation().setMappedBy(mappedBy);
        this.setMappedBy_(mappedBy);
    }

    protected void setMappedBy_(String mappedBy) {
        String old = this.mappedBy;
        this.mappedBy = mappedBy;
        this.firePropertyChanged("mappedBy", old, mappedBy);
    }

    public XmlInverseReferenceAnnotation getXmlInverseReferenceAnnotation() {
        return (XmlInverseReferenceAnnotation)this.getJavaResourceAttribute().getAnnotation("org.eclipse.persistence.oxm.annotations.XmlInverseReference");
    }

    public String getResourceMappedBy() {
        return this.getXmlInverseReferenceAnnotation().getMappedBy();
    }

    protected JaxbClassMapping getReferencedClassMapping() {
        String referencedClassName = this.getValueTypeName();
        return referencedClassName == null ? null : this.getContextRoot().getClassMapping(referencedClassName);
    }

    protected JaxbPersistentAttribute getReferencedAttribute() {
        String mappedBy = this.getMappedBy();
        if (StringTools.isBlank((String)mappedBy)) {
            return null;
        }
        JaxbClassMapping referencedClassMapping = this.getReferencedClassMapping();
        if (referencedClassMapping == null) {
            return null;
        }
        JaxbPersistentAttribute tempResult = null;
        for (JaxbPersistentAttribute attribute : referencedClassMapping.getAllLocallyDefinedAttributes()) {
            if (!attribute.getName().equals(mappedBy)) continue;
            if (attribute.getMappingKey() == "xml-transient") {
                tempResult = attribute;
                continue;
            }
            return attribute;
        }
        return tempResult;
    }

    public Iterable<String> getCompletionProposals(int pos) {
        Iterable<String> result = super.getCompletionProposals(pos);
        if (!IterableTools.isEmpty((Iterable)result)) {
            return result;
        }
        if (this.getXmlInverseReferenceAnnotation().mappedByTouches(pos)) {
            result = this.getMappedByProposals();
        }
        if (!IterableTools.isEmpty((Iterable)result)) {
            return result;
        }
        return EmptyIterable.instance();
    }

    protected Iterable<String> getMappedByProposals() {
        JaxbClassMapping referencedClassMapping = this.getReferencedClassMapping();
        if (referencedClassMapping == null) {
            return EmptyIterable.instance();
        }
        return IterableTools.transform((Iterable)IterableTools.transform((Iterable)referencedClassMapping.getAllLocallyDefinedAttributes(), (Transformer)JaxbPersistentAttribute.NAME_TRANSFORMER), (Transformer)StringTools.JAVA_STRING_LITERAL_CONTENT_TRANSFORMER);
    }

    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        this.validateMappedBy(messages, reporter);
    }

    protected void validateMappedBy(List<IMessage> messages, IReporter reporter) {
        if (StringTools.isBlank((String)this.mappedBy)) {
            messages.add(this.buildValidationMessage(this.getMappedByValidationTextRange(), JptJaxbEclipseLinkCoreValidationMessages.XML_INVERSE_REFERENCE__MAPPED_BY_NOT_SPECIFIED));
            return;
        }
        JaxbClassMapping referencedClassMapping = this.getReferencedClassMapping();
        if (referencedClassMapping == null) {
            return;
        }
        JaxbPersistentAttribute referencedAttribute = this.getReferencedAttribute();
        if (referencedAttribute == null) {
            messages.add(this.buildValidationMessage(this.getMappedByValidationTextRange(), JptJaxbEclipseLinkCoreValidationMessages.XML_INVERSE_REFERENCE__MAPPED_BY_NOT_RESOLVED, new Object[]{this.mappedBy, referencedClassMapping.getTypeName().getFullyQualifiedName()}));
        } else if (!ArrayTools.contains((Object[])this.getValidReferencedAttributeMappingKeys(), (Object)referencedAttribute.getMappingKey())) {
            messages.add(this.buildValidationMessage(this.getMappedByValidationTextRange(), JptJaxbEclipseLinkCoreValidationMessages.XML_INVERSE_REFERENCE__MAPPED_BY_ILLEGAL_MAPPING_TYPE, new Object[]{this.mappedBy, referencedClassMapping.getTypeName().getFullyQualifiedName()}));
        }
    }

    protected String[] getValidReferencedAttributeMappingKeys() {
        return VALID_REFERENCED_ATTRIBUTE_MAPPING_KEYS;
    }

    protected TextRange getMappedByValidationTextRange() {
        return this.getXmlInverseReferenceAnnotation().getMappedByValidationTextRange();
    }
}

