/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.deque;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.NoSuchElementException;
import org.eclipse.jpt.common.utility.deque.Deque;

public abstract class AbstractArrayDeque<E>
implements Deque<E>,
Cloneable,
Serializable {
    protected transient E[] elements;
    protected transient int head = 0;
    protected transient int tail = 0;
    protected int size = 0;
    private static final long serialVersionUID = 1L;

    protected AbstractArrayDeque(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal capacity: " + initialCapacity);
        }
        this.elements = new Object[initialCapacity];
    }

    @Override
    public void enqueueTail(E element) {
        this.elements[this.tail] = element;
        if (++this.tail == this.elements.length) {
            this.tail = 0;
        }
        ++this.size;
    }

    @Override
    public void enqueueHead(E element) {
        if (this.head == 0) {
            this.head = this.elements.length;
        }
        this.elements[--this.head] = element;
        ++this.size;
    }

    @Override
    public E dequeueHead() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        E element = this.elements[this.head];
        this.elements[this.head] = null;
        if (++this.head == this.elements.length) {
            this.head = 0;
        }
        --this.size;
        return element;
    }

    @Override
    public E dequeueTail() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        if (this.tail == 0) {
            this.tail = this.elements.length;
        }
        E element = this.elements[--this.tail];
        this.elements[this.tail] = null;
        --this.size;
        return element;
    }

    @Override
    public E peekHead() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        return this.elements[this.head];
    }

    @Override
    public E peekTail() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        int index = this.tail == 0 ? this.elements.length : this.tail;
        return this.elements[--index];
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    public AbstractArrayDeque<E> clone() {
        try {
            AbstractArrayDeque clone = (AbstractArrayDeque)super.clone();
            Object[] array = (Object[])this.elements.clone();
            clone.elements = array;
            return clone;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public String toString() {
        return Arrays.toString(this.copyElements(this.size));
    }

    protected E[] copyElements(int newCapacity) {
        Object[] newElements = new Object[newCapacity];
        if (this.size != 0) {
            E[] oldElements = this.elements;
            int t = this.tail;
            if (t == 0) {
                t = oldElements.length;
            }
            if (this.head < t) {
                System.arraycopy(oldElements, this.head, newElements, 0, this.size);
            } else {
                int fragmentSize = oldElements.length - this.head;
                System.arraycopy(oldElements, this.head, newElements, 0, fragmentSize);
                System.arraycopy(oldElements, 0, newElements, fragmentSize, this.size - fragmentSize);
            }
        }
        return newElements;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        E[] array = this.elements;
        int elementsLength = array.length;
        stream.writeInt(elementsLength);
        if (this.size == 0) {
            return;
        }
        int t = this.tail;
        if (t == 0) {
            t = elementsLength;
        }
        if (this.head < t) {
            int i = this.head;
            while (i < t) {
                stream.writeObject(array[i]);
                ++i;
            }
        } else {
            int i = this.head;
            while (i < elementsLength) {
                stream.writeObject(array[i]);
                ++i;
            }
            i = 0;
            while (i < this.tail) {
                stream.writeObject(array[i]);
                ++i;
            }
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        int elementsLength = stream.readInt();
        Object[] array = new Object[elementsLength];
        int i = 0;
        while (i < this.size) {
            array[i] = stream.readObject();
            ++i;
        }
        this.elements = array;
        this.head = 0;
        this.tail = this.size;
    }
}

