/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.extension;

import java.time.format.DateTimeParseException;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.junit.jupiter.engine.extension.TimeoutDuration;

class TimeoutDurationParser {
    private static final Pattern PATTERN = Pattern.compile("([1-9]\\d*) ?((?:[n\u03bcm]?s)|m|h|d)?", 66);
    private static final Map<String, TimeUnit> UNITS_BY_ABBREVIATION = Map.of("ns", TimeUnit.NANOSECONDS, "\u03bcs", TimeUnit.MICROSECONDS, "ms", TimeUnit.MILLISECONDS, "s", TimeUnit.SECONDS, "m", TimeUnit.MINUTES, "h", TimeUnit.HOURS, "d", TimeUnit.DAYS);

    TimeoutDurationParser() {
    }

    TimeoutDuration parse(CharSequence text) throws DateTimeParseException {
        Matcher matcher = PATTERN.matcher(text);
        if (matcher.matches()) {
            long value = Long.parseLong(matcher.group(1));
            String unitAbbreviation = matcher.group(2);
            TimeUnit unit = unitAbbreviation == null ? TimeUnit.SECONDS : Objects.requireNonNull(UNITS_BY_ABBREVIATION.get(unitAbbreviation.toLowerCase(Locale.ENGLISH)));
            return new TimeoutDuration(value, unit);
        }
        throw new DateTimeParseException("Timeout duration is not in the expected format (<number> [ns|\u03bcs|ms|s|m|h|d])", text, 0);
    }
}

