/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.descriptor;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.jspecify.annotations.Nullable;
import org.junit.jupiter.api.parallel.ResourceLockTarget;
import org.junit.jupiter.api.parallel.ResourceLocksProvider;
import org.junit.jupiter.engine.descriptor.ExclusiveResourceCollector;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.support.hierarchical.ExclusiveResource;

interface ResourceLockAware
extends TestDescriptor {
    default public Stream<ExclusiveResource> determineExclusiveResources() {
        ArrayDeque<ResourceLockAware> ancestors = new ArrayDeque<ResourceLockAware>();
        TestDescriptor parent = this.getParent().orElse(null);
        while (parent instanceof ResourceLockAware) {
            ResourceLockAware resourceLockAwareParent = (ResourceLockAware)parent;
            ancestors.addFirst(resourceLockAwareParent);
            parent = parent.getParent().orElse(null);
        }
        Function<ResourceLocksProvider, Set<ResourceLocksProvider.Lock>> evaluator = this.getResourceLocksProviderEvaluator();
        if (ancestors.isEmpty()) {
            return this.determineOwnExclusiveResources(evaluator);
        }
        Stream<ExclusiveResource> parentStaticResourcesForChildren = ((ResourceLockAware)ancestors.getLast()).getExclusiveResourceCollector().getStaticResourcesFor(ResourceLockTarget.CHILDREN);
        Stream ancestorDynamicResources = ancestors.stream().map(ResourceLockAware::getExclusiveResourceCollector).flatMap(collector -> collector.getDynamicResources(evaluator));
        return Stream.of(ancestorDynamicResources, parentStaticResourcesForChildren, this.determineOwnExclusiveResources(evaluator)).flatMap(s -> s);
    }

    default public Stream<ExclusiveResource> determineOwnExclusiveResources(Function<ResourceLocksProvider, Set<ResourceLocksProvider.Lock>> providerToLocks) {
        return this.getExclusiveResourceCollector().getAllExclusiveResources(providerToLocks);
    }

    public ExclusiveResourceCollector getExclusiveResourceCollector();

    public Function<ResourceLocksProvider, Set<ResourceLocksProvider.Lock>> getResourceLocksProviderEvaluator();

    public static Function<ResourceLocksProvider, Set<ResourceLocksProvider.Lock>> enclosingInstanceTypesDependentResourceLocksProviderEvaluator(final Supplier<List<Class<?>>> enclosingInstanceTypesSupplier, final BiFunction<ResourceLocksProvider, List<Class<?>>, Set<ResourceLocksProvider.Lock>> evaluator) {
        return new Function<ResourceLocksProvider, Set<ResourceLocksProvider.Lock>>(){
            private @Nullable List<Class<?>> enclosingInstanceTypes;

            @Override
            public Set<ResourceLocksProvider.Lock> apply(ResourceLocksProvider provider) {
                if (this.enclosingInstanceTypes == null) {
                    this.enclosingInstanceTypes = List.copyOf((Collection)enclosingInstanceTypesSupplier.get());
                }
                return (Set)evaluator.apply(provider, this.enclosingInstanceTypes);
            }
        };
    }
}

